/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.transform.WebhookMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Webhook
implements StructuredPojo,
ToCopyableBuilder<Builder, Webhook> {
    private final String url;
    private final String payloadUrl;
    private final String secret;
    private final String branchFilter;
    private final Instant lastModifiedSecret;

    private Webhook(BuilderImpl builder) {
        this.url = builder.url;
        this.payloadUrl = builder.payloadUrl;
        this.secret = builder.secret;
        this.branchFilter = builder.branchFilter;
        this.lastModifiedSecret = builder.lastModifiedSecret;
    }

    public String url() {
        return this.url;
    }

    public String payloadUrl() {
        return this.payloadUrl;
    }

    public String secret() {
        return this.secret;
    }

    public String branchFilter() {
        return this.branchFilter;
    }

    public Instant lastModifiedSecret() {
        return this.lastModifiedSecret;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.secret());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedSecret());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Webhook)) {
            return false;
        }
        Webhook other = (Webhook)obj;
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.payloadUrl(), other.payloadUrl()) && Objects.equals(this.secret(), other.secret()) && Objects.equals(this.branchFilter(), other.branchFilter()) && Objects.equals(this.lastModifiedSecret(), other.lastModifiedSecret());
    }

    public String toString() {
        return ToString.builder((String)"Webhook").add("Url", (Object)this.url()).add("PayloadUrl", (Object)this.payloadUrl()).add("Secret", (Object)this.secret()).add("BranchFilter", (Object)this.branchFilter()).add("LastModifiedSecret", (Object)this.lastModifiedSecret()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "payloadUrl": {
                return Optional.ofNullable(clazz.cast(this.payloadUrl()));
            }
            case "secret": {
                return Optional.ofNullable(clazz.cast(this.secret()));
            }
            case "branchFilter": {
                return Optional.ofNullable(clazz.cast(this.branchFilter()));
            }
            case "lastModifiedSecret": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedSecret()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WebhookMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String url;
        private String payloadUrl;
        private String secret;
        private String branchFilter;
        private Instant lastModifiedSecret;

        private BuilderImpl() {
        }

        private BuilderImpl(Webhook model) {
            this.url(model.url);
            this.payloadUrl(model.payloadUrl);
            this.secret(model.secret);
            this.branchFilter(model.branchFilter);
            this.lastModifiedSecret(model.lastModifiedSecret);
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getPayloadUrl() {
            return this.payloadUrl;
        }

        @Override
        public final Builder payloadUrl(String payloadUrl) {
            this.payloadUrl = payloadUrl;
            return this;
        }

        public final void setPayloadUrl(String payloadUrl) {
            this.payloadUrl = payloadUrl;
        }

        public final String getSecret() {
            return this.secret;
        }

        @Override
        public final Builder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public final void setSecret(String secret) {
            this.secret = secret;
        }

        public final String getBranchFilter() {
            return this.branchFilter;
        }

        @Override
        public final Builder branchFilter(String branchFilter) {
            this.branchFilter = branchFilter;
            return this;
        }

        public final void setBranchFilter(String branchFilter) {
            this.branchFilter = branchFilter;
        }

        public final Instant getLastModifiedSecret() {
            return this.lastModifiedSecret;
        }

        @Override
        public final Builder lastModifiedSecret(Instant lastModifiedSecret) {
            this.lastModifiedSecret = lastModifiedSecret;
            return this;
        }

        public final void setLastModifiedSecret(Instant lastModifiedSecret) {
            this.lastModifiedSecret = lastModifiedSecret;
        }

        public Webhook build() {
            return new Webhook(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Webhook> {
        public Builder url(String var1);

        public Builder payloadUrl(String var1);

        public Builder secret(String var1);

        public Builder branchFilter(String var1);

        public Builder lastModifiedSecret(Instant var1);
    }
}

