/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.CacheType;
import software.amazon.awssdk.services.codebuild.transform.ProjectCacheMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectCache
implements StructuredPojo,
ToCopyableBuilder<Builder, ProjectCache> {
    private final String type;
    private final String location;

    private ProjectCache(BuilderImpl builder) {
        this.type = builder.type;
        this.location = builder.location;
    }

    public CacheType type() {
        return CacheType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectCache)) {
            return false;
        }
        ProjectCache other = (ProjectCache)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.location(), other.location());
    }

    public String toString() {
        return ToString.builder((String)"ProjectCache").add("Type", (Object)this.typeAsString()).add("Location", (Object)this.location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectCacheMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectCache model) {
            this.type(model.type);
            this.location(model.location);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CacheType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public ProjectCache build() {
            return new ProjectCache(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProjectCache> {
        public Builder type(String var1);

        public Builder type(CacheType var1);

        public Builder location(String var1);
    }
}

