/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.EnvironmentImage;
import software.amazon.awssdk.services.codebuild.model.EnvironmentImagesCopier;
import software.amazon.awssdk.services.codebuild.model.LanguageType;
import software.amazon.awssdk.services.codebuild.transform.EnvironmentLanguageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentLanguage
implements StructuredPojo,
ToCopyableBuilder<Builder, EnvironmentLanguage> {
    private final String language;
    private final List<EnvironmentImage> images;

    private EnvironmentLanguage(BuilderImpl builder) {
        this.language = builder.language;
        this.images = builder.images;
    }

    public LanguageType language() {
        return LanguageType.fromValue(this.language);
    }

    public String languageAsString() {
        return this.language;
    }

    public List<EnvironmentImage> images() {
        return this.images;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.images());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentLanguage)) {
            return false;
        }
        EnvironmentLanguage other = (EnvironmentLanguage)obj;
        return Objects.equals(this.languageAsString(), other.languageAsString()) && Objects.equals(this.images(), other.images());
    }

    public String toString() {
        return ToString.builder((String)"EnvironmentLanguage").add("Language", (Object)this.languageAsString()).add("Images", this.images()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "language": {
                return Optional.ofNullable(clazz.cast(this.languageAsString()));
            }
            case "images": {
                return Optional.ofNullable(clazz.cast(this.images()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentLanguageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String language;
        private List<EnvironmentImage> images = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentLanguage model) {
            this.language(model.language);
            this.images(model.images);
        }

        public final String getLanguage() {
            return this.language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(LanguageType language) {
            this.language(language.toString());
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public final Collection<EnvironmentImage.Builder> getImages() {
            return this.images != null ? (Collection)this.images.stream().map(EnvironmentImage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder images(Collection<EnvironmentImage> images) {
            this.images = EnvironmentImagesCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(EnvironmentImage ... images) {
            this.images(Arrays.asList(images));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Consumer<EnvironmentImage.Builder> ... images) {
            this.images(Stream.of(images).map(c -> (EnvironmentImage)((EnvironmentImage.Builder)EnvironmentImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImages(Collection<EnvironmentImage.BuilderImpl> images) {
            this.images = EnvironmentImagesCopier.copyFromBuilder(images);
        }

        public EnvironmentLanguage build() {
            return new EnvironmentLanguage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentLanguage> {
        public Builder language(String var1);

        public Builder language(LanguageType var1);

        public Builder images(Collection<EnvironmentImage> var1);

        public Builder images(EnvironmentImage ... var1);

        public Builder images(Consumer<EnvironmentImage.Builder> ... var1);
    }
}

