/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.codebuild.model.BuildIdsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListBuildsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListBuildsResponse> {
    private final List<String> ids;
    private final String nextToken;

    private ListBuildsResponse(BuilderImpl builder) {
        this.ids = builder.ids;
        this.nextToken = builder.nextToken;
    }

    public List<String> ids() {
        return this.ids;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ids() == null ? 0 : this.ids().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuildsResponse)) {
            return false;
        }
        ListBuildsResponse other = (ListBuildsResponse)((Object)obj);
        if (other.ids() == null ^ this.ids() == null) {
            return false;
        }
        if (other.ids() != null && !other.ids().equals(this.ids())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ids() != null) {
            sb.append("Ids: ").append(this.ids()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> ids;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBuildsResponse model) {
            this.setIds(model.ids);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getIds() {
            return this.ids;
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = BuildIdsCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String ... ids) {
            if (this.ids == null) {
                this.ids = new ArrayList<String>(ids.length);
            }
            for (String e : ids) {
                this.ids.add(e);
            }
            return this;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = BuildIdsCopier.copy(ids);
        }

        @SafeVarargs
        public final void setIds(String ... ids) {
            if (this.ids == null) {
                this.ids = new ArrayList<String>(ids.length);
            }
            for (String e : ids) {
                this.ids.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListBuildsResponse build() {
            return new ListBuildsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListBuildsResponse> {
        public Builder ids(Collection<String> var1);

        public Builder ids(String ... var1);

        public Builder nextToken(String var1);
    }
}

