/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PackageGroupAssociationType {
    STRONG("STRONG"),
    WEAK("WEAK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PackageGroupAssociationType> VALUE_MAP;
    private final String value;

    private PackageGroupAssociationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PackageGroupAssociationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PackageGroupAssociationType> knownValues() {
        EnumSet<PackageGroupAssociationType> knownValues = EnumSet.allOf(PackageGroupAssociationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PackageGroupAssociationType.class, PackageGroupAssociationType::toString);
    }
}

