/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactRequest;
import software.amazon.awssdk.services.codeartifact.model.EndpointType;
import software.amazon.awssdk.services.codeartifact.model.PackageFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRepositoryEndpointRequest
extends CodeartifactRequest
implements ToCopyableBuilder<Builder, GetRepositoryEndpointRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(GetRepositoryEndpointRequest.getter(GetRepositoryEndpointRequest::domain)).setter(GetRepositoryEndpointRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()}).build();
    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainOwner").getter(GetRepositoryEndpointRequest.getter(GetRepositoryEndpointRequest::domainOwner)).setter(GetRepositoryEndpointRequest.setter(Builder::domainOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()}).build();
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repository").getter(GetRepositoryEndpointRequest.getter(GetRepositoryEndpointRequest::repository)).setter(GetRepositoryEndpointRequest.setter(Builder::repository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("repository").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(GetRepositoryEndpointRequest.getter(GetRepositoryEndpointRequest::formatAsString)).setter(GetRepositoryEndpointRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("format").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpointType").getter(GetRepositoryEndpointRequest.getter(GetRepositoryEndpointRequest::endpointTypeAsString)).setter(GetRepositoryEndpointRequest.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endpointType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, DOMAIN_OWNER_FIELD, REPOSITORY_FIELD, FORMAT_FIELD, ENDPOINT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRepositoryEndpointRequest.memberNameToFieldInitializer();
    private final String domain;
    private final String domainOwner;
    private final String repository;
    private final String format;
    private final String endpointType;

    private GetRepositoryEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.repository = builder.repository;
        this.format = builder.format;
        this.endpointType = builder.endpointType;
    }

    public final String domain() {
        return this.domain;
    }

    public final String domainOwner() {
        return this.domainOwner;
    }

    public final String repository() {
        return this.repository;
    }

    public final PackageFormat format() {
        return PackageFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final EndpointType endpointType() {
        return EndpointType.fromValue(this.endpointType);
    }

    public final String endpointTypeAsString() {
        return this.endpointType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRepositoryEndpointRequest)) {
            return false;
        }
        GetRepositoryEndpointRequest other = (GetRepositoryEndpointRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainOwner(), other.domainOwner()) && Objects.equals(this.repository(), other.repository()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetRepositoryEndpointRequest").add("Domain", (Object)this.domain()).add("DomainOwner", (Object)this.domainOwner()).add("Repository", (Object)this.repository()).add("Format", (Object)this.formatAsString()).add("EndpointType", (Object)this.endpointTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "domainOwner": {
                return Optional.ofNullable(clazz.cast(this.domainOwner()));
            }
            case "repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "endpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("domain", DOMAIN_FIELD);
        map.put("domain-owner", DOMAIN_OWNER_FIELD);
        map.put("repository", REPOSITORY_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("endpointType", ENDPOINT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRepositoryEndpointRequest, T> g) {
        return obj -> g.apply((GetRepositoryEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactRequest.BuilderImpl
    implements Builder {
        private String domain;
        private String domainOwner;
        private String repository;
        private String format;
        private String endpointType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRepositoryEndpointRequest model) {
            super(model);
            this.domain(model.domain);
            this.domainOwner(model.domainOwner);
            this.repository(model.repository);
            this.format(model.format);
            this.endpointType(model.endpointType);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainOwner() {
            return this.domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final String getRepository() {
            return this.repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRepositoryEndpointRequest build() {
            return new GetRepositoryEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeartifactRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRepositoryEndpointRequest> {
        public Builder domain(String var1);

        public Builder domainOwner(String var1);

        public Builder repository(String var1);

        public Builder format(String var1);

        public Builder format(PackageFormat var1);

        public Builder endpointType(String var1);

        public Builder endpointType(EndpointType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

