/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactClient;
import software.amazon.awssdk.services.codeartifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeartifact.model.ListPackageGroupsRequest;
import software.amazon.awssdk.services.codeartifact.model.ListPackageGroupsResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupSummary;

public class ListPackageGroupsIterable
implements SdkIterable<ListPackageGroupsResponse> {
    private final CodeartifactClient client;
    private final ListPackageGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPackageGroupsIterable(CodeartifactClient client, ListPackageGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPackageGroupsResponseFetcher();
    }

    public Iterator<ListPackageGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PackageGroupSummary> packageGroups() {
        Function<ListPackageGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.packageGroups() != null) {
                return response.packageGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPackageGroupsResponseFetcher
    implements SyncPageFetcher<ListPackageGroupsResponse> {
        private ListPackageGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListPackageGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPackageGroupsResponse nextPage(ListPackageGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListPackageGroupsIterable.this.client.listPackageGroups(ListPackageGroupsIterable.this.firstRequest);
            }
            return ListPackageGroupsIterable.this.client.listPackageGroups((ListPackageGroupsRequest)((Object)ListPackageGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

