/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codeartifact.CodeartifactClient;
import software.amazon.awssdk.services.codeartifact.CodeartifactClientBuilder;
import software.amazon.awssdk.services.codeartifact.CodeartifactServiceClientConfiguration;
import software.amazon.awssdk.services.codeartifact.DefaultCodeartifactBaseClientBuilder;
import software.amazon.awssdk.services.codeartifact.DefaultCodeartifactClient;
import software.amazon.awssdk.services.codeartifact.endpoints.CodeartifactEndpointProvider;

@SdkInternalApi
final class DefaultCodeartifactClientBuilder
extends DefaultCodeartifactBaseClientBuilder<CodeartifactClientBuilder, CodeartifactClient>
implements CodeartifactClientBuilder {
    DefaultCodeartifactClientBuilder() {
    }

    @Override
    public DefaultCodeartifactClientBuilder endpointProvider(CodeartifactEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeartifactClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeartifactClientBuilder.validateClientOptions(clientConfiguration);
        CodeartifactServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeartifactClient client = new DefaultCodeartifactClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeartifactServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeartifactServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

