/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.OpenSearchResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenSearchCollection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenSearchCollection> {
    private static final SdkField<String> COLLECTION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collectionEndpoint").getter(OpenSearchCollection.getter(OpenSearchCollection::collectionEndpoint)).setter(OpenSearchCollection.setter(Builder::collectionEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionEndpoint").build()}).build();
    private static final SdkField<String> COLLECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collectionArn").getter(OpenSearchCollection.getter(OpenSearchCollection::collectionArn)).setter(OpenSearchCollection.setter(Builder::collectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionArn").build()}).build();
    private static final SdkField<OpenSearchResourceStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(OpenSearchCollection.getter(OpenSearchCollection::status)).setter(OpenSearchCollection.setter(Builder::status)).constructor(OpenSearchResourceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ENDPOINT_FIELD, COLLECTION_ARN_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OpenSearchCollection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String collectionEndpoint;
    private final String collectionArn;
    private final OpenSearchResourceStatus status;

    private OpenSearchCollection(BuilderImpl builder) {
        this.collectionEndpoint = builder.collectionEndpoint;
        this.collectionArn = builder.collectionArn;
        this.status = builder.status;
    }

    public final String collectionEndpoint() {
        return this.collectionEndpoint;
    }

    public final String collectionArn() {
        return this.collectionArn;
    }

    public final OpenSearchResourceStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenSearchCollection)) {
            return false;
        }
        OpenSearchCollection other = (OpenSearchCollection)obj;
        return Objects.equals(this.collectionEndpoint(), other.collectionEndpoint()) && Objects.equals(this.collectionArn(), other.collectionArn()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"OpenSearchCollection").add("CollectionEndpoint", (Object)this.collectionEndpoint()).add("CollectionArn", (Object)this.collectionArn()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "collectionEndpoint": {
                return Optional.ofNullable(clazz.cast(this.collectionEndpoint()));
            }
            case "collectionArn": {
                return Optional.ofNullable(clazz.cast(this.collectionArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("collectionEndpoint", COLLECTION_ENDPOINT_FIELD);
        map.put("collectionArn", COLLECTION_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenSearchCollection, T> g) {
        return obj -> g.apply((OpenSearchCollection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String collectionEndpoint;
        private String collectionArn;
        private OpenSearchResourceStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenSearchCollection model) {
            this.collectionEndpoint(model.collectionEndpoint);
            this.collectionArn(model.collectionArn);
            this.status(model.status);
        }

        public final String getCollectionEndpoint() {
            return this.collectionEndpoint;
        }

        public final void setCollectionEndpoint(String collectionEndpoint) {
            this.collectionEndpoint = collectionEndpoint;
        }

        @Override
        public final Builder collectionEndpoint(String collectionEndpoint) {
            this.collectionEndpoint = collectionEndpoint;
            return this;
        }

        public final String getCollectionArn() {
            return this.collectionArn;
        }

        public final void setCollectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
        }

        @Override
        public final Builder collectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
            return this;
        }

        public final OpenSearchResourceStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(OpenSearchResourceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(OpenSearchResourceStatus status) {
            this.status = status;
            return this;
        }

        public OpenSearchCollection build() {
            return new OpenSearchCollection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenSearchCollection> {
        public Builder collectionEndpoint(String var1);

        public Builder collectionArn(String var1);

        public Builder status(OpenSearchResourceStatus var1);

        default public Builder status(Consumer<OpenSearchResourceStatus.Builder> status) {
            return this.status((OpenSearchResourceStatus)((OpenSearchResourceStatus.Builder)OpenSearchResourceStatus.builder().applyMutation(status)).build());
        }
    }
}

