/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLogFieldsRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, GetLogFieldsRequest> {
    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceName").getter(GetLogFieldsRequest.getter(GetLogFieldsRequest::dataSourceName)).setter(GetLogFieldsRequest.setter(Builder::dataSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceName").build()}).build();
    private static final SdkField<String> DATA_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceType").getter(GetLogFieldsRequest.getter(GetLogFieldsRequest::dataSourceType)).setter(GetLogFieldsRequest.setter(Builder::dataSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_NAME_FIELD, DATA_SOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLogFieldsRequest.memberNameToFieldInitializer();
    private final String dataSourceName;
    private final String dataSourceType;

    private GetLogFieldsRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceName = builder.dataSourceName;
        this.dataSourceType = builder.dataSourceType;
    }

    public final String dataSourceName() {
        return this.dataSourceName;
    }

    public final String dataSourceType() {
        return this.dataSourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogFieldsRequest)) {
            return false;
        }
        GetLogFieldsRequest other = (GetLogFieldsRequest)((Object)obj);
        return Objects.equals(this.dataSourceName(), other.dataSourceName()) && Objects.equals(this.dataSourceType(), other.dataSourceType());
    }

    public final String toString() {
        return ToString.builder((String)"GetLogFieldsRequest").add("DataSourceName", (Object)this.dataSourceName()).add("DataSourceType", (Object)this.dataSourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSourceName": {
                return Optional.ofNullable(clazz.cast(this.dataSourceName()));
            }
            case "dataSourceType": {
                return Optional.ofNullable(clazz.cast(this.dataSourceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("dataSourceName", DATA_SOURCE_NAME_FIELD);
        map.put("dataSourceType", DATA_SOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLogFieldsRequest, T> g) {
        return obj -> g.apply((GetLogFieldsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String dataSourceName;
        private String dataSourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogFieldsRequest model) {
            super(model);
            this.dataSourceName(model.dataSourceName);
            this.dataSourceType(model.dataSourceType);
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final String getDataSourceType() {
            return this.dataSourceType;
        }

        public final void setDataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
        }

        @Override
        public final Builder dataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLogFieldsRequest build() {
            return new GetLogFieldsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLogFieldsRequest> {
        public Builder dataSourceName(String var1);

        public Builder dataSourceType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

