/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetScheduledQueryHistoryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetScheduledQueryHistoryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TriggerHistoryRecord;

public class GetScheduledQueryHistoryIterable
implements SdkIterable<GetScheduledQueryHistoryResponse> {
    private final CloudWatchLogsClient client;
    private final GetScheduledQueryHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetScheduledQueryHistoryIterable(CloudWatchLogsClient client, GetScheduledQueryHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetScheduledQueryHistoryResponseFetcher();
    }

    public Iterator<GetScheduledQueryHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TriggerHistoryRecord> triggerHistory() {
        Function<GetScheduledQueryHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.triggerHistory() != null) {
                return response.triggerHistory().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetScheduledQueryHistoryResponseFetcher
    implements SyncPageFetcher<GetScheduledQueryHistoryResponse> {
        private GetScheduledQueryHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetScheduledQueryHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetScheduledQueryHistoryResponse nextPage(GetScheduledQueryHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetScheduledQueryHistoryIterable.this.client.getScheduledQueryHistory(GetScheduledQueryHistoryIterable.this.firstRequest);
            }
            return GetScheduledQueryHistoryIterable.this.client.getScheduledQueryHistory((GetScheduledQueryHistoryRequest)((Object)GetScheduledQueryHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

