/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ImportFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateImportTaskRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, CreateImportTaskRequest> {
    private static final SdkField<String> IMPORT_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importSourceArn").getter(CreateImportTaskRequest.getter(CreateImportTaskRequest::importSourceArn)).setter(CreateImportTaskRequest.setter(Builder::importSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importSourceArn").build()}).build();
    private static final SdkField<String> IMPORT_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importRoleArn").getter(CreateImportTaskRequest.getter(CreateImportTaskRequest::importRoleArn)).setter(CreateImportTaskRequest.setter(Builder::importRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importRoleArn").build()}).build();
    private static final SdkField<ImportFilter> IMPORT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("importFilter").getter(CreateImportTaskRequest.getter(CreateImportTaskRequest::importFilter)).setter(CreateImportTaskRequest.setter(Builder::importFilter)).constructor(ImportFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_SOURCE_ARN_FIELD, IMPORT_ROLE_ARN_FIELD, IMPORT_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateImportTaskRequest.memberNameToFieldInitializer();
    private final String importSourceArn;
    private final String importRoleArn;
    private final ImportFilter importFilter;

    private CreateImportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.importSourceArn = builder.importSourceArn;
        this.importRoleArn = builder.importRoleArn;
        this.importFilter = builder.importFilter;
    }

    public final String importSourceArn() {
        return this.importSourceArn;
    }

    public final String importRoleArn() {
        return this.importRoleArn;
    }

    public final ImportFilter importFilter() {
        return this.importFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.importSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.importRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.importFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImportTaskRequest)) {
            return false;
        }
        CreateImportTaskRequest other = (CreateImportTaskRequest)((Object)obj);
        return Objects.equals(this.importSourceArn(), other.importSourceArn()) && Objects.equals(this.importRoleArn(), other.importRoleArn()) && Objects.equals(this.importFilter(), other.importFilter());
    }

    public final String toString() {
        return ToString.builder((String)"CreateImportTaskRequest").add("ImportSourceArn", (Object)this.importSourceArn()).add("ImportRoleArn", (Object)this.importRoleArn()).add("ImportFilter", (Object)this.importFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importSourceArn": {
                return Optional.ofNullable(clazz.cast(this.importSourceArn()));
            }
            case "importRoleArn": {
                return Optional.ofNullable(clazz.cast(this.importRoleArn()));
            }
            case "importFilter": {
                return Optional.ofNullable(clazz.cast(this.importFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("importSourceArn", IMPORT_SOURCE_ARN_FIELD);
        map.put("importRoleArn", IMPORT_ROLE_ARN_FIELD);
        map.put("importFilter", IMPORT_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateImportTaskRequest, T> g) {
        return obj -> g.apply((CreateImportTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String importSourceArn;
        private String importRoleArn;
        private ImportFilter importFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImportTaskRequest model) {
            super(model);
            this.importSourceArn(model.importSourceArn);
            this.importRoleArn(model.importRoleArn);
            this.importFilter(model.importFilter);
        }

        public final String getImportSourceArn() {
            return this.importSourceArn;
        }

        public final void setImportSourceArn(String importSourceArn) {
            this.importSourceArn = importSourceArn;
        }

        @Override
        public final Builder importSourceArn(String importSourceArn) {
            this.importSourceArn = importSourceArn;
            return this;
        }

        public final String getImportRoleArn() {
            return this.importRoleArn;
        }

        public final void setImportRoleArn(String importRoleArn) {
            this.importRoleArn = importRoleArn;
        }

        @Override
        public final Builder importRoleArn(String importRoleArn) {
            this.importRoleArn = importRoleArn;
            return this;
        }

        public final ImportFilter.Builder getImportFilter() {
            return this.importFilter != null ? this.importFilter.toBuilder() : null;
        }

        public final void setImportFilter(ImportFilter.BuilderImpl importFilter) {
            this.importFilter = importFilter != null ? importFilter.build() : null;
        }

        @Override
        public final Builder importFilter(ImportFilter importFilter) {
            this.importFilter = importFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImportTaskRequest build() {
            return new CreateImportTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateImportTaskRequest> {
        public Builder importSourceArn(String var1);

        public Builder importRoleArn(String var1);

        public Builder importFilter(ImportFilter var1);

        default public Builder importFilter(Consumer<ImportFilter.Builder> importFilter) {
            return this.importFilter((ImportFilter)((ImportFilter.Builder)ImportFilter.builder().applyMutation(importFilter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

