/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExtractedValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricFilterMatchRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricFilterMatchRecord> {
    private static final SdkField<Long> EVENT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(MetricFilterMatchRecord.getter(MetricFilterMatchRecord::eventNumber)).setter(MetricFilterMatchRecord.setter(Builder::eventNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventNumber").build()}).build();
    private static final SdkField<String> EVENT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MetricFilterMatchRecord.getter(MetricFilterMatchRecord::eventMessage)).setter(MetricFilterMatchRecord.setter(Builder::eventMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventMessage").build()}).build();
    private static final SdkField<Map<String, String>> EXTRACTED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(MetricFilterMatchRecord.getter(MetricFilterMatchRecord::extractedValues)).setter(MetricFilterMatchRecord.setter(Builder::extractedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extractedValues").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_NUMBER_FIELD, EVENT_MESSAGE_FIELD, EXTRACTED_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long eventNumber;
    private final String eventMessage;
    private final Map<String, String> extractedValues;

    private MetricFilterMatchRecord(BuilderImpl builder) {
        this.eventNumber = builder.eventNumber;
        this.eventMessage = builder.eventMessage;
        this.extractedValues = builder.extractedValues;
    }

    public Long eventNumber() {
        return this.eventNumber;
    }

    public String eventMessage() {
        return this.eventMessage;
    }

    public Map<String, String> extractedValues() {
        return this.extractedValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.extractedValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricFilterMatchRecord)) {
            return false;
        }
        MetricFilterMatchRecord other = (MetricFilterMatchRecord)obj;
        return Objects.equals(this.eventNumber(), other.eventNumber()) && Objects.equals(this.eventMessage(), other.eventMessage()) && Objects.equals(this.extractedValues(), other.extractedValues());
    }

    public String toString() {
        return ToString.builder((String)"MetricFilterMatchRecord").add("EventNumber", (Object)this.eventNumber()).add("EventMessage", (Object)this.eventMessage()).add("ExtractedValues", this.extractedValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventNumber": {
                return Optional.ofNullable(clazz.cast(this.eventNumber()));
            }
            case "eventMessage": {
                return Optional.ofNullable(clazz.cast(this.eventMessage()));
            }
            case "extractedValues": {
                return Optional.ofNullable(clazz.cast(this.extractedValues()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricFilterMatchRecord, T> g) {
        return obj -> g.apply((MetricFilterMatchRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long eventNumber;
        private String eventMessage;
        private Map<String, String> extractedValues = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricFilterMatchRecord model) {
            this.eventNumber(model.eventNumber);
            this.eventMessage(model.eventMessage);
            this.extractedValues(model.extractedValues);
        }

        public final Long getEventNumber() {
            return this.eventNumber;
        }

        @Override
        public final Builder eventNumber(Long eventNumber) {
            this.eventNumber = eventNumber;
            return this;
        }

        public final void setEventNumber(Long eventNumber) {
            this.eventNumber = eventNumber;
        }

        public final String getEventMessage() {
            return this.eventMessage;
        }

        @Override
        public final Builder eventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
            return this;
        }

        public final void setEventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
        }

        public final Map<String, String> getExtractedValues() {
            return this.extractedValues;
        }

        @Override
        public final Builder extractedValues(Map<String, String> extractedValues) {
            this.extractedValues = ExtractedValuesCopier.copy(extractedValues);
            return this;
        }

        public final void setExtractedValues(Map<String, String> extractedValues) {
            this.extractedValues = ExtractedValuesCopier.copy(extractedValues);
        }

        public MetricFilterMatchRecord build() {
            return new MetricFilterMatchRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricFilterMatchRecord> {
        public Builder eventNumber(Long var1);

        public Builder eventMessage(String var1);

        public Builder extractedValues(Map<String, String> var1);
    }
}

