/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TriggerHistoryRecord;
import software.amazon.awssdk.services.cloudwatchlogs.model.TriggerHistoryRecordListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetScheduledQueryHistoryResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, GetScheduledQueryHistoryResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetScheduledQueryHistoryResponse.getter(GetScheduledQueryHistoryResponse::name)).setter(GetScheduledQueryHistoryResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SCHEDULED_QUERY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scheduledQueryArn").getter(GetScheduledQueryHistoryResponse.getter(GetScheduledQueryHistoryResponse::scheduledQueryArn)).setter(GetScheduledQueryHistoryResponse.setter(Builder::scheduledQueryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledQueryArn").build()}).build();
    private static final SdkField<List<TriggerHistoryRecord>> TRIGGER_HISTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("triggerHistory").getter(GetScheduledQueryHistoryResponse.getter(GetScheduledQueryHistoryResponse::triggerHistory)).setter(GetScheduledQueryHistoryResponse.setter(Builder::triggerHistory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerHistory").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TriggerHistoryRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetScheduledQueryHistoryResponse.getter(GetScheduledQueryHistoryResponse::nextToken)).setter(GetScheduledQueryHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCHEDULED_QUERY_ARN_FIELD, TRIGGER_HISTORY_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetScheduledQueryHistoryResponse.memberNameToFieldInitializer();
    private final String name;
    private final String scheduledQueryArn;
    private final List<TriggerHistoryRecord> triggerHistory;
    private final String nextToken;

    private GetScheduledQueryHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.scheduledQueryArn = builder.scheduledQueryArn;
        this.triggerHistory = builder.triggerHistory;
        this.nextToken = builder.nextToken;
    }

    public final String name() {
        return this.name;
    }

    public final String scheduledQueryArn() {
        return this.scheduledQueryArn;
    }

    public final boolean hasTriggerHistory() {
        return this.triggerHistory != null && !(this.triggerHistory instanceof SdkAutoConstructList);
    }

    public final List<TriggerHistoryRecord> triggerHistory() {
        return this.triggerHistory;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledQueryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggerHistory() ? this.triggerHistory() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScheduledQueryHistoryResponse)) {
            return false;
        }
        GetScheduledQueryHistoryResponse other = (GetScheduledQueryHistoryResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.scheduledQueryArn(), other.scheduledQueryArn()) && this.hasTriggerHistory() == other.hasTriggerHistory() && Objects.equals(this.triggerHistory(), other.triggerHistory()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetScheduledQueryHistoryResponse").add("Name", (Object)this.name()).add("ScheduledQueryArn", (Object)this.scheduledQueryArn()).add("TriggerHistory", this.hasTriggerHistory() ? this.triggerHistory() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "scheduledQueryArn": {
                return Optional.ofNullable(clazz.cast(this.scheduledQueryArn()));
            }
            case "triggerHistory": {
                return Optional.ofNullable(clazz.cast(this.triggerHistory()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("scheduledQueryArn", SCHEDULED_QUERY_ARN_FIELD);
        map.put("triggerHistory", TRIGGER_HISTORY_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetScheduledQueryHistoryResponse, T> g) {
        return obj -> g.apply((GetScheduledQueryHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private String name;
        private String scheduledQueryArn;
        private List<TriggerHistoryRecord> triggerHistory = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScheduledQueryHistoryResponse model) {
            super(model);
            this.name(model.name);
            this.scheduledQueryArn(model.scheduledQueryArn);
            this.triggerHistory(model.triggerHistory);
            this.nextToken(model.nextToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getScheduledQueryArn() {
            return this.scheduledQueryArn;
        }

        public final void setScheduledQueryArn(String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
        }

        @Override
        public final Builder scheduledQueryArn(String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
            return this;
        }

        public final List<TriggerHistoryRecord.Builder> getTriggerHistory() {
            List<TriggerHistoryRecord.Builder> result = TriggerHistoryRecordListCopier.copyToBuilder(this.triggerHistory);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggerHistory(Collection<TriggerHistoryRecord.BuilderImpl> triggerHistory) {
            this.triggerHistory = TriggerHistoryRecordListCopier.copyFromBuilder(triggerHistory);
        }

        @Override
        public final Builder triggerHistory(Collection<TriggerHistoryRecord> triggerHistory) {
            this.triggerHistory = TriggerHistoryRecordListCopier.copy(triggerHistory);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerHistory(TriggerHistoryRecord ... triggerHistory) {
            this.triggerHistory(Arrays.asList(triggerHistory));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerHistory(Consumer<TriggerHistoryRecord.Builder> ... triggerHistory) {
            this.triggerHistory(Stream.of(triggerHistory).map(c -> (TriggerHistoryRecord)((TriggerHistoryRecord.Builder)TriggerHistoryRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetScheduledQueryHistoryResponse build() {
            return new GetScheduledQueryHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetScheduledQueryHistoryResponse> {
        public Builder name(String var1);

        public Builder scheduledQueryArn(String var1);

        public Builder triggerHistory(Collection<TriggerHistoryRecord> var1);

        public Builder triggerHistory(TriggerHistoryRecord ... var1);

        public Builder triggerHistory(Consumer<TriggerHistoryRecord.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

