/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model.getlogobjectresponsestream;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.cloudwatchlogs.model.FieldsData;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogObjectResponseHandler;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogObjectResponseStream;

/**
 * A specialization of {@code software.amazon.awssdk.services.cloudwatchlogs.model.FieldsData} that represents the
 * {@code GetLogObjectResponseStream$fields} event. Do not use this class directly. Instead, use the static builder
 * methods on {@link software.amazon.awssdk.services.cloudwatchlogs.model.GetLogObjectResponseStream}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultFields extends FieldsData {
    private static final long serialVersionUID = 1L;

    DefaultFields(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(GetLogObjectResponseHandler.Visitor visitor) {
        visitor.visitFields(this);
    }

    @Override
    public GetLogObjectResponseStream.EventType sdkEventType() {
        return GetLogObjectResponseStream.EventType.FIELDS;
    }

    public interface Builder extends FieldsData.Builder {
        @Override
        DefaultFields build();
    }

    private static final class BuilderImpl extends FieldsData.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultFields event) {
            super(event);
        }

        @Override
        public DefaultFields build() {
            return new DefaultFields(this);
        }
    }
}
