/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartLiveTailRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<StartLiveTailRequest.Builder, StartLiveTailRequest> {
    private static final SdkField<List<String>> LOG_GROUP_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logGroupIdentifiers")
            .getter(getter(StartLiveTailRequest::logGroupIdentifiers))
            .setter(setter(Builder::logGroupIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LOG_STREAM_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logStreamNames")
            .getter(getter(StartLiveTailRequest::logStreamNames))
            .setter(setter(Builder::logStreamNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LOG_STREAM_NAME_PREFIXES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logStreamNamePrefixes")
            .getter(getter(StartLiveTailRequest::logStreamNamePrefixes))
            .setter(setter(Builder::logStreamNamePrefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamNamePrefixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOG_EVENT_FILTER_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logEventFilterPattern").getter(getter(StartLiveTailRequest::logEventFilterPattern))
            .setter(setter(Builder::logEventFilterPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logEventFilterPattern").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_IDENTIFIERS_FIELD,
            LOG_STREAM_NAMES_FIELD, LOG_STREAM_NAME_PREFIXES_FIELD, LOG_EVENT_FILTER_PATTERN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> logGroupIdentifiers;

    private final List<String> logStreamNames;

    private final List<String> logStreamNamePrefixes;

    private final String logEventFilterPattern;

    private StartLiveTailRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupIdentifiers = builder.logGroupIdentifiers;
        this.logStreamNames = builder.logStreamNames;
        this.logStreamNamePrefixes = builder.logStreamNamePrefixes;
        this.logEventFilterPattern = builder.logEventFilterPattern;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogGroupIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogGroupIdentifiers() {
        return logGroupIdentifiers != null && !(logGroupIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array where each item in the array is a log group to include in the Live Tail session.
     * </p>
     * <p>
     * Specify each log group by its ARN.
     * </p>
     * <p>
     * If you specify an ARN, the ARN can't end with an asterisk (*).
     * </p>
     * <note>
     * <p>
     * You can include up to 10 log groups.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogGroupIdentifiers} method.
     * </p>
     * 
     * @return An array where each item in the array is a log group to include in the Live Tail session.</p>
     *         <p>
     *         Specify each log group by its ARN.
     *         </p>
     *         <p>
     *         If you specify an ARN, the ARN can't end with an asterisk (*).
     *         </p>
     *         <note>
     *         <p>
     *         You can include up to 10 log groups.
     *         </p>
     */
    public final List<String> logGroupIdentifiers() {
        return logGroupIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogStreamNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogStreamNames() {
        return logStreamNames != null && !(logStreamNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you specify this parameter, then only log events in the log streams that you specify here are included in the
     * Live Tail session.
     * </p>
     * <p>
     * If you specify this field, you can't also specify the <code>logStreamNamePrefixes</code> field.
     * </p>
     * <note>
     * <p>
     * You can specify this parameter only if you specify only one log group in <code>logGroupIdentifiers</code>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogStreamNames} method.
     * </p>
     * 
     * @return If you specify this parameter, then only log events in the log streams that you specify here are included
     *         in the Live Tail session.</p>
     *         <p>
     *         If you specify this field, you can't also specify the <code>logStreamNamePrefixes</code> field.
     *         </p>
     *         <note>
     *         <p>
     *         You can specify this parameter only if you specify only one log group in <code>logGroupIdentifiers</code>
     *         .
     *         </p>
     */
    public final List<String> logStreamNames() {
        return logStreamNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogStreamNamePrefixes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLogStreamNamePrefixes() {
        return logStreamNamePrefixes != null && !(logStreamNamePrefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you specify this parameter, then only log events in the log streams that have names that start with the
     * prefixes that you specify here are included in the Live Tail session.
     * </p>
     * <p>
     * If you specify this field, you can't also specify the <code>logStreamNames</code> field.
     * </p>
     * <note>
     * <p>
     * You can specify this parameter only if you specify only one log group in <code>logGroupIdentifiers</code>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogStreamNamePrefixes} method.
     * </p>
     * 
     * @return If you specify this parameter, then only log events in the log streams that have names that start with
     *         the prefixes that you specify here are included in the Live Tail session.</p>
     *         <p>
     *         If you specify this field, you can't also specify the <code>logStreamNames</code> field.
     *         </p>
     *         <note>
     *         <p>
     *         You can specify this parameter only if you specify only one log group in <code>logGroupIdentifiers</code>
     *         .
     *         </p>
     */
    public final List<String> logStreamNamePrefixes() {
        return logStreamNamePrefixes;
    }

    /**
     * <p>
     * An optional pattern to use to filter the results to include only log events that match the pattern. For example,
     * a filter pattern of <code>error 404</code> causes only log events that include both <code>error</code> and
     * <code>404</code> to be included in the Live Tail stream.
     * </p>
     * <p>
     * Regular expression filter patterns are supported.
     * </p>
     * <p>
     * For more information about filter pattern syntax, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern
     * Syntax</a>.
     * </p>
     * 
     * @return An optional pattern to use to filter the results to include only log events that match the pattern. For
     *         example, a filter pattern of <code>error 404</code> causes only log events that include both
     *         <code>error</code> and <code>404</code> to be included in the Live Tail stream.</p>
     *         <p>
     *         Regular expression filter patterns are supported.
     *         </p>
     *         <p>
     *         For more information about filter pattern syntax, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and
     *         Pattern Syntax</a>.
     */
    public final String logEventFilterPattern() {
        return logEventFilterPattern;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLogGroupIdentifiers() ? logGroupIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLogStreamNames() ? logStreamNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLogStreamNamePrefixes() ? logStreamNamePrefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logEventFilterPattern());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartLiveTailRequest)) {
            return false;
        }
        StartLiveTailRequest other = (StartLiveTailRequest) obj;
        return hasLogGroupIdentifiers() == other.hasLogGroupIdentifiers()
                && Objects.equals(logGroupIdentifiers(), other.logGroupIdentifiers())
                && hasLogStreamNames() == other.hasLogStreamNames() && Objects.equals(logStreamNames(), other.logStreamNames())
                && hasLogStreamNamePrefixes() == other.hasLogStreamNamePrefixes()
                && Objects.equals(logStreamNamePrefixes(), other.logStreamNamePrefixes())
                && Objects.equals(logEventFilterPattern(), other.logEventFilterPattern());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartLiveTailRequest")
                .add("LogGroupIdentifiers", hasLogGroupIdentifiers() ? logGroupIdentifiers() : null)
                .add("LogStreamNames", hasLogStreamNames() ? logStreamNames() : null)
                .add("LogStreamNamePrefixes", hasLogStreamNamePrefixes() ? logStreamNamePrefixes() : null)
                .add("LogEventFilterPattern", logEventFilterPattern()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupIdentifiers":
            return Optional.ofNullable(clazz.cast(logGroupIdentifiers()));
        case "logStreamNames":
            return Optional.ofNullable(clazz.cast(logStreamNames()));
        case "logStreamNamePrefixes":
            return Optional.ofNullable(clazz.cast(logStreamNamePrefixes()));
        case "logEventFilterPattern":
            return Optional.ofNullable(clazz.cast(logEventFilterPattern()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logGroupIdentifiers", LOG_GROUP_IDENTIFIERS_FIELD);
        map.put("logStreamNames", LOG_STREAM_NAMES_FIELD);
        map.put("logStreamNamePrefixes", LOG_STREAM_NAME_PREFIXES_FIELD);
        map.put("logEventFilterPattern", LOG_EVENT_FILTER_PATTERN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartLiveTailRequest, T> g) {
        return obj -> g.apply((StartLiveTailRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartLiveTailRequest> {
        /**
         * <p>
         * An array where each item in the array is a log group to include in the Live Tail session.
         * </p>
         * <p>
         * Specify each log group by its ARN.
         * </p>
         * <p>
         * If you specify an ARN, the ARN can't end with an asterisk (*).
         * </p>
         * <note>
         * <p>
         * You can include up to 10 log groups.
         * </p>
         * </note>
         * 
         * @param logGroupIdentifiers
         *        An array where each item in the array is a log group to include in the Live Tail session.</p>
         *        <p>
         *        Specify each log group by its ARN.
         *        </p>
         *        <p>
         *        If you specify an ARN, the ARN can't end with an asterisk (*).
         *        </p>
         *        <note>
         *        <p>
         *        You can include up to 10 log groups.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupIdentifiers(Collection<String> logGroupIdentifiers);

        /**
         * <p>
         * An array where each item in the array is a log group to include in the Live Tail session.
         * </p>
         * <p>
         * Specify each log group by its ARN.
         * </p>
         * <p>
         * If you specify an ARN, the ARN can't end with an asterisk (*).
         * </p>
         * <note>
         * <p>
         * You can include up to 10 log groups.
         * </p>
         * </note>
         * 
         * @param logGroupIdentifiers
         *        An array where each item in the array is a log group to include in the Live Tail session.</p>
         *        <p>
         *        Specify each log group by its ARN.
         *        </p>
         *        <p>
         *        If you specify an ARN, the ARN can't end with an asterisk (*).
         *        </p>
         *        <note>
         *        <p>
         *        You can include up to 10 log groups.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupIdentifiers(String... logGroupIdentifiers);

        /**
         * <p>
         * If you specify this parameter, then only log events in the log streams that you specify here are included in
         * the Live Tail session.
         * </p>
         * <p>
         * If you specify this field, you can't also specify the <code>logStreamNamePrefixes</code> field.
         * </p>
         * <note>
         * <p>
         * You can specify this parameter only if you specify only one log group in <code>logGroupIdentifiers</code>.
         * </p>
         * </note>
         * 
         * @param logStreamNames
         *        If you specify this parameter, then only log events in the log streams that you specify here are
         *        included in the Live Tail session.</p>
         *        <p>
         *        If you specify this field, you can't also specify the <code>logStreamNamePrefixes</code> field.
         *        </p>
         *        <note>
         *        <p>
         *        You can specify this parameter only if you specify only one log group in
         *        <code>logGroupIdentifiers</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamNames(Collection<String> logStreamNames);

        /**
         * <p>
         * If you specify this parameter, then only log events in the log streams that you specify here are included in
         * the Live Tail session.
         * </p>
         * <p>
         * If you specify this field, you can't also specify the <code>logStreamNamePrefixes</code> field.
         * </p>
         * <note>
         * <p>
         * You can specify this parameter only if you specify only one log group in <code>logGroupIdentifiers</code>.
         * </p>
         * </note>
         * 
         * @param logStreamNames
         *        If you specify this parameter, then only log events in the log streams that you specify here are
         *        included in the Live Tail session.</p>
         *        <p>
         *        If you specify this field, you can't also specify the <code>logStreamNamePrefixes</code> field.
         *        </p>
         *        <note>
         *        <p>
         *        You can specify this parameter only if you specify only one log group in
         *        <code>logGroupIdentifiers</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamNames(String... logStreamNames);

        /**
         * <p>
         * If you specify this parameter, then only log events in the log streams that have names that start with the
         * prefixes that you specify here are included in the Live Tail session.
         * </p>
         * <p>
         * If you specify this field, you can't also specify the <code>logStreamNames</code> field.
         * </p>
         * <note>
         * <p>
         * You can specify this parameter only if you specify only one log group in <code>logGroupIdentifiers</code>.
         * </p>
         * </note>
         * 
         * @param logStreamNamePrefixes
         *        If you specify this parameter, then only log events in the log streams that have names that start with
         *        the prefixes that you specify here are included in the Live Tail session.</p>
         *        <p>
         *        If you specify this field, you can't also specify the <code>logStreamNames</code> field.
         *        </p>
         *        <note>
         *        <p>
         *        You can specify this parameter only if you specify only one log group in
         *        <code>logGroupIdentifiers</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamNamePrefixes(Collection<String> logStreamNamePrefixes);

        /**
         * <p>
         * If you specify this parameter, then only log events in the log streams that have names that start with the
         * prefixes that you specify here are included in the Live Tail session.
         * </p>
         * <p>
         * If you specify this field, you can't also specify the <code>logStreamNames</code> field.
         * </p>
         * <note>
         * <p>
         * You can specify this parameter only if you specify only one log group in <code>logGroupIdentifiers</code>.
         * </p>
         * </note>
         * 
         * @param logStreamNamePrefixes
         *        If you specify this parameter, then only log events in the log streams that have names that start with
         *        the prefixes that you specify here are included in the Live Tail session.</p>
         *        <p>
         *        If you specify this field, you can't also specify the <code>logStreamNames</code> field.
         *        </p>
         *        <note>
         *        <p>
         *        You can specify this parameter only if you specify only one log group in
         *        <code>logGroupIdentifiers</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamNamePrefixes(String... logStreamNamePrefixes);

        /**
         * <p>
         * An optional pattern to use to filter the results to include only log events that match the pattern. For
         * example, a filter pattern of <code>error 404</code> causes only log events that include both
         * <code>error</code> and <code>404</code> to be included in the Live Tail stream.
         * </p>
         * <p>
         * Regular expression filter patterns are supported.
         * </p>
         * <p>
         * For more information about filter pattern syntax, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and
         * Pattern Syntax</a>.
         * </p>
         * 
         * @param logEventFilterPattern
         *        An optional pattern to use to filter the results to include only log events that match the pattern.
         *        For example, a filter pattern of <code>error 404</code> causes only log events that include both
         *        <code>error</code> and <code>404</code> to be included in the Live Tail stream.</p>
         *        <p>
         *        Regular expression filter patterns are supported.
         *        </p>
         *        <p>
         *        For more information about filter pattern syntax, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and
         *        Pattern Syntax</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logEventFilterPattern(String logEventFilterPattern);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private List<String> logGroupIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> logStreamNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> logStreamNamePrefixes = DefaultSdkAutoConstructList.getInstance();

        private String logEventFilterPattern;

        private BuilderImpl() {
        }

        private BuilderImpl(StartLiveTailRequest model) {
            super(model);
            logGroupIdentifiers(model.logGroupIdentifiers);
            logStreamNames(model.logStreamNames);
            logStreamNamePrefixes(model.logStreamNamePrefixes);
            logEventFilterPattern(model.logEventFilterPattern);
        }

        public final Collection<String> getLogGroupIdentifiers() {
            if (logGroupIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return logGroupIdentifiers;
        }

        public final void setLogGroupIdentifiers(Collection<String> logGroupIdentifiers) {
            this.logGroupIdentifiers = StartLiveTailLogGroupIdentifiersCopier.copy(logGroupIdentifiers);
        }

        @Override
        public final Builder logGroupIdentifiers(Collection<String> logGroupIdentifiers) {
            this.logGroupIdentifiers = StartLiveTailLogGroupIdentifiersCopier.copy(logGroupIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupIdentifiers(String... logGroupIdentifiers) {
            logGroupIdentifiers(Arrays.asList(logGroupIdentifiers));
            return this;
        }

        public final Collection<String> getLogStreamNames() {
            if (logStreamNames instanceof SdkAutoConstructList) {
                return null;
            }
            return logStreamNames;
        }

        public final void setLogStreamNames(Collection<String> logStreamNames) {
            this.logStreamNames = InputLogStreamNamesCopier.copy(logStreamNames);
        }

        @Override
        public final Builder logStreamNames(Collection<String> logStreamNames) {
            this.logStreamNames = InputLogStreamNamesCopier.copy(logStreamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreamNames(String... logStreamNames) {
            logStreamNames(Arrays.asList(logStreamNames));
            return this;
        }

        public final Collection<String> getLogStreamNamePrefixes() {
            if (logStreamNamePrefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return logStreamNamePrefixes;
        }

        public final void setLogStreamNamePrefixes(Collection<String> logStreamNamePrefixes) {
            this.logStreamNamePrefixes = InputLogStreamNamesCopier.copy(logStreamNamePrefixes);
        }

        @Override
        public final Builder logStreamNamePrefixes(Collection<String> logStreamNamePrefixes) {
            this.logStreamNamePrefixes = InputLogStreamNamesCopier.copy(logStreamNamePrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreamNamePrefixes(String... logStreamNamePrefixes) {
            logStreamNamePrefixes(Arrays.asList(logStreamNamePrefixes));
            return this;
        }

        public final String getLogEventFilterPattern() {
            return logEventFilterPattern;
        }

        public final void setLogEventFilterPattern(String logEventFilterPattern) {
            this.logEventFilterPattern = logEventFilterPattern;
        }

        @Override
        public final Builder logEventFilterPattern(String logEventFilterPattern) {
            this.logEventFilterPattern = logEventFilterPattern;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartLiveTailRequest build() {
            return new StartLiveTailRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
