/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSubscriptionFilterRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<PutSubscriptionFilterRequest.Builder, PutSubscriptionFilterRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(PutSubscriptionFilterRequest::logGroupName))
            .setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterName").getter(getter(PutSubscriptionFilterRequest::filterName))
            .setter(setter(Builder::filterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterName").build()).build();

    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterPattern").getter(getter(PutSubscriptionFilterRequest::filterPattern))
            .setter(setter(Builder::filterPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationArn").getter(getter(PutSubscriptionFilterRequest::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(PutSubscriptionFilterRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> DISTRIBUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("distribution").getter(getter(PutSubscriptionFilterRequest::distributionAsString))
            .setter(setter(Builder::distribution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distribution").build()).build();

    private static final SdkField<Boolean> APPLY_ON_TRANSFORMED_LOGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("applyOnTransformedLogs").getter(getter(PutSubscriptionFilterRequest::applyOnTransformedLogs))
            .setter(setter(Builder::applyOnTransformedLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyOnTransformedLogs").build())
            .build();

    private static final SdkField<String> FIELD_SELECTION_CRITERIA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldSelectionCriteria").getter(getter(PutSubscriptionFilterRequest::fieldSelectionCriteria))
            .setter(setter(Builder::fieldSelectionCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldSelectionCriteria").build())
            .build();

    private static final SdkField<List<String>> EMIT_SYSTEM_FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("emitSystemFields")
            .getter(getter(PutSubscriptionFilterRequest::emitSystemFields))
            .setter(setter(Builder::emitSystemFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emitSystemFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            FILTER_NAME_FIELD, FILTER_PATTERN_FIELD, DESTINATION_ARN_FIELD, ROLE_ARN_FIELD, DISTRIBUTION_FIELD,
            APPLY_ON_TRANSFORMED_LOGS_FIELD, FIELD_SELECTION_CRITERIA_FIELD, EMIT_SYSTEM_FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String logGroupName;

    private final String filterName;

    private final String filterPattern;

    private final String destinationArn;

    private final String roleArn;

    private final String distribution;

    private final Boolean applyOnTransformedLogs;

    private final String fieldSelectionCriteria;

    private final List<String> emitSystemFields;

    private PutSubscriptionFilterRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.filterName = builder.filterName;
        this.filterPattern = builder.filterPattern;
        this.destinationArn = builder.destinationArn;
        this.roleArn = builder.roleArn;
        this.distribution = builder.distribution;
        this.applyOnTransformedLogs = builder.applyOnTransformedLogs;
        this.fieldSelectionCriteria = builder.fieldSelectionCriteria;
        this.emitSystemFields = builder.emitSystemFields;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * A name for the subscription filter. If you are updating an existing filter, you must specify the correct name in
     * <code>filterName</code>. To find the name of the filter currently associated with a log group, use <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeSubscriptionFilters.html"
     * >DescribeSubscriptionFilters</a>.
     * </p>
     * 
     * @return A name for the subscription filter. If you are updating an existing filter, you must specify the correct
     *         name in <code>filterName</code>. To find the name of the filter currently associated with a log group,
     *         use <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeSubscriptionFilters.html"
     *         >DescribeSubscriptionFilters</a>.
     */
    public final String filterName() {
        return filterName;
    }

    /**
     * <p>
     * A filter pattern for subscribing to a filtered stream of log events.
     * </p>
     * 
     * @return A filter pattern for subscribing to a filtered stream of log events.
     */
    public final String filterPattern() {
        return filterPattern;
    }

    /**
     * <p>
     * The ARN of the destination to deliver matching log events to. Currently, the supported destinations are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * A logical destination (specified using an ARN) belonging to a different account, for cross-account delivery.
     * </p>
     * <p>
     * If you're setting up a cross-account subscription, the destination must have an IAM policy associated with it.
     * The IAM policy must allow the sender to send logs to the destination. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html"
     * >PutDestinationPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Kinesis Data Firehose delivery stream belonging to the same account as the subscription filter, for
     * same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Lambda function belonging to the same account as the subscription filter, for same-account delivery.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The ARN of the destination to deliver matching log events to. Currently, the supported destinations
     *         are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account
     *         delivery.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A logical destination (specified using an ARN) belonging to a different account, for cross-account
     *         delivery.
     *         </p>
     *         <p>
     *         If you're setting up a cross-account subscription, the destination must have an IAM policy associated
     *         with it. The IAM policy must allow the sender to send logs to the destination. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html"
     *         >PutDestinationPolicy</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A Kinesis Data Firehose delivery stream belonging to the same account as the subscription filter, for
     *         same-account delivery.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A Lambda function belonging to the same account as the subscription filter, for same-account delivery.
     *         </p>
     *         </li>
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the destination
     * stream. You don't need to provide the ARN when you are working with a logical destination for cross-account
     * delivery.
     * </p>
     * 
     * @return The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the
     *         destination stream. You don't need to provide the ARN when you are working with a logical destination for
     *         cross-account delivery.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The method used to distribute log data to the destination. By default, log data is grouped by log stream, but the
     * grouping can be set to random for a more even distribution. This property is only applicable when the destination
     * is an Amazon Kinesis data stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distribution} will
     * return {@link Distribution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distributionAsString}.
     * </p>
     * 
     * @return The method used to distribute log data to the destination. By default, log data is grouped by log stream,
     *         but the grouping can be set to random for a more even distribution. This property is only applicable when
     *         the destination is an Amazon Kinesis data stream.
     * @see Distribution
     */
    public final Distribution distribution() {
        return Distribution.fromValue(distribution);
    }

    /**
     * <p>
     * The method used to distribute log data to the destination. By default, log data is grouped by log stream, but the
     * grouping can be set to random for a more even distribution. This property is only applicable when the destination
     * is an Amazon Kinesis data stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distribution} will
     * return {@link Distribution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distributionAsString}.
     * </p>
     * 
     * @return The method used to distribute log data to the destination. By default, log data is grouped by log stream,
     *         but the grouping can be set to random for a more even distribution. This property is only applicable when
     *         the destination is an Amazon Kinesis data stream.
     * @see Distribution
     */
    public final String distributionAsString() {
        return distribution;
    }

    /**
     * <p>
     * This parameter is valid only for log groups that have an active log transformer. For more information about log
     * transformers, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html"
     * >PutTransformer</a>.
     * </p>
     * <p>
     * If the log group uses either a log-group level or account-level transformer, and you specify <code>true</code>,
     * the subscription filter will be applied on the transformed version of the log events instead of the original
     * ingested log events.
     * </p>
     * 
     * @return This parameter is valid only for log groups that have an active log transformer. For more information
     *         about log transformers, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html"
     *         >PutTransformer</a>.</p>
     *         <p>
     *         If the log group uses either a log-group level or account-level transformer, and you specify
     *         <code>true</code>, the subscription filter will be applied on the transformed version of the log events
     *         instead of the original ingested log events.
     */
    public final Boolean applyOnTransformedLogs() {
        return applyOnTransformedLogs;
    }

    /**
     * <p>
     * A filter expression that specifies which log events should be processed by this subscription filter based on
     * system fields such as source account and source region. Uses selection criteria syntax with operators like
     * <code>=</code>, <code>!=</code>, <code>AND</code>, <code>OR</code>, <code>IN</code>, <code>NOT IN</code>.
     * Example: <code>@aws.region NOT IN ["cn-north-1"]</code> or
     * <code>@aws.account = "123456789012" AND @aws.region = "us-east-1"</code>. Maximum length: 2000 characters.
     * </p>
     * 
     * @return A filter expression that specifies which log events should be processed by this subscription filter based
     *         on system fields such as source account and source region. Uses selection criteria syntax with operators
     *         like <code>=</code>, <code>!=</code>, <code>AND</code>, <code>OR</code>, <code>IN</code>,
     *         <code>NOT IN</code>. Example: <code>@aws.region NOT IN ["cn-north-1"]</code> or
     *         <code>@aws.account = "123456789012" AND @aws.region = "us-east-1"</code>. Maximum length: 2000
     *         characters.
     */
    public final String fieldSelectionCriteria() {
        return fieldSelectionCriteria;
    }

    /**
     * For responses, this returns true if the service returned a value for the EmitSystemFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEmitSystemFields() {
        return emitSystemFields != null && !(emitSystemFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of system fields to include in the log events sent to the subscription destination. Valid values are
     * <code>@aws.account</code> and <code>@aws.region</code>. These fields provide source information for centralized
     * log data in the forwarded payload.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmitSystemFields} method.
     * </p>
     * 
     * @return A list of system fields to include in the log events sent to the subscription destination. Valid values
     *         are <code>@aws.account</code> and <code>@aws.region</code>. These fields provide source information for
     *         centralized log data in the forwarded payload.
     */
    public final List<String> emitSystemFields() {
        return emitSystemFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(filterName());
        hashCode = 31 * hashCode + Objects.hashCode(filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(distributionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applyOnTransformedLogs());
        hashCode = 31 * hashCode + Objects.hashCode(fieldSelectionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(hasEmitSystemFields() ? emitSystemFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSubscriptionFilterRequest)) {
            return false;
        }
        PutSubscriptionFilterRequest other = (PutSubscriptionFilterRequest) obj;
        return Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(filterName(), other.filterName())
                && Objects.equals(filterPattern(), other.filterPattern())
                && Objects.equals(destinationArn(), other.destinationArn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(distributionAsString(), other.distributionAsString())
                && Objects.equals(applyOnTransformedLogs(), other.applyOnTransformedLogs())
                && Objects.equals(fieldSelectionCriteria(), other.fieldSelectionCriteria())
                && hasEmitSystemFields() == other.hasEmitSystemFields()
                && Objects.equals(emitSystemFields(), other.emitSystemFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSubscriptionFilterRequest").add("LogGroupName", logGroupName())
                .add("FilterName", filterName()).add("FilterPattern", filterPattern()).add("DestinationArn", destinationArn())
                .add("RoleArn", roleArn()).add("Distribution", distributionAsString())
                .add("ApplyOnTransformedLogs", applyOnTransformedLogs()).add("FieldSelectionCriteria", fieldSelectionCriteria())
                .add("EmitSystemFields", hasEmitSystemFields() ? emitSystemFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "filterName":
            return Optional.ofNullable(clazz.cast(filterName()));
        case "filterPattern":
            return Optional.ofNullable(clazz.cast(filterPattern()));
        case "destinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "distribution":
            return Optional.ofNullable(clazz.cast(distributionAsString()));
        case "applyOnTransformedLogs":
            return Optional.ofNullable(clazz.cast(applyOnTransformedLogs()));
        case "fieldSelectionCriteria":
            return Optional.ofNullable(clazz.cast(fieldSelectionCriteria()));
        case "emitSystemFields":
            return Optional.ofNullable(clazz.cast(emitSystemFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        map.put("filterName", FILTER_NAME_FIELD);
        map.put("filterPattern", FILTER_PATTERN_FIELD);
        map.put("destinationArn", DESTINATION_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("distribution", DISTRIBUTION_FIELD);
        map.put("applyOnTransformedLogs", APPLY_ON_TRANSFORMED_LOGS_FIELD);
        map.put("fieldSelectionCriteria", FIELD_SELECTION_CRITERIA_FIELD);
        map.put("emitSystemFields", EMIT_SYSTEM_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSubscriptionFilterRequest, T> g) {
        return obj -> g.apply((PutSubscriptionFilterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutSubscriptionFilterRequest> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * A name for the subscription filter. If you are updating an existing filter, you must specify the correct name
         * in <code>filterName</code>. To find the name of the filter currently associated with a log group, use <a
         * href=
         * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeSubscriptionFilters.html"
         * >DescribeSubscriptionFilters</a>.
         * </p>
         * 
         * @param filterName
         *        A name for the subscription filter. If you are updating an existing filter, you must specify the
         *        correct name in <code>filterName</code>. To find the name of the filter currently associated with a
         *        log group, use <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeSubscriptionFilters.html"
         *        >DescribeSubscriptionFilters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterName(String filterName);

        /**
         * <p>
         * A filter pattern for subscribing to a filtered stream of log events.
         * </p>
         * 
         * @param filterPattern
         *        A filter pattern for subscribing to a filtered stream of log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * The ARN of the destination to deliver matching log events to. Currently, the supported destinations are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account delivery.
         * </p>
         * </li>
         * <li>
         * <p>
         * A logical destination (specified using an ARN) belonging to a different account, for cross-account delivery.
         * </p>
         * <p>
         * If you're setting up a cross-account subscription, the destination must have an IAM policy associated with
         * it. The IAM policy must allow the sender to send logs to the destination. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html"
         * >PutDestinationPolicy</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A Kinesis Data Firehose delivery stream belonging to the same account as the subscription filter, for
         * same-account delivery.
         * </p>
         * </li>
         * <li>
         * <p>
         * A Lambda function belonging to the same account as the subscription filter, for same-account delivery.
         * </p>
         * </li>
         * </ul>
         * 
         * @param destinationArn
         *        The ARN of the destination to deliver matching log events to. Currently, the supported destinations
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account
         *        delivery.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A logical destination (specified using an ARN) belonging to a different account, for cross-account
         *        delivery.
         *        </p>
         *        <p>
         *        If you're setting up a cross-account subscription, the destination must have an IAM policy associated
         *        with it. The IAM policy must allow the sender to send logs to the destination. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html"
         *        >PutDestinationPolicy</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A Kinesis Data Firehose delivery stream belonging to the same account as the subscription filter, for
         *        same-account delivery.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A Lambda function belonging to the same account as the subscription filter, for same-account delivery.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the
         * destination stream. You don't need to provide the ARN when you are working with a logical destination for
         * cross-account delivery.
         * </p>
         * 
         * @param roleArn
         *        The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the
         *        destination stream. You don't need to provide the ARN when you are working with a logical destination
         *        for cross-account delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The method used to distribute log data to the destination. By default, log data is grouped by log stream, but
         * the grouping can be set to random for a more even distribution. This property is only applicable when the
         * destination is an Amazon Kinesis data stream.
         * </p>
         * 
         * @param distribution
         *        The method used to distribute log data to the destination. By default, log data is grouped by log
         *        stream, but the grouping can be set to random for a more even distribution. This property is only
         *        applicable when the destination is an Amazon Kinesis data stream.
         * @see Distribution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Distribution
         */
        Builder distribution(String distribution);

        /**
         * <p>
         * The method used to distribute log data to the destination. By default, log data is grouped by log stream, but
         * the grouping can be set to random for a more even distribution. This property is only applicable when the
         * destination is an Amazon Kinesis data stream.
         * </p>
         * 
         * @param distribution
         *        The method used to distribute log data to the destination. By default, log data is grouped by log
         *        stream, but the grouping can be set to random for a more even distribution. This property is only
         *        applicable when the destination is an Amazon Kinesis data stream.
         * @see Distribution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Distribution
         */
        Builder distribution(Distribution distribution);

        /**
         * <p>
         * This parameter is valid only for log groups that have an active log transformer. For more information about
         * log transformers, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html"
         * >PutTransformer</a>.
         * </p>
         * <p>
         * If the log group uses either a log-group level or account-level transformer, and you specify
         * <code>true</code>, the subscription filter will be applied on the transformed version of the log events
         * instead of the original ingested log events.
         * </p>
         * 
         * @param applyOnTransformedLogs
         *        This parameter is valid only for log groups that have an active log transformer. For more information
         *        about log transformers, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html"
         *        >PutTransformer</a>.</p>
         *        <p>
         *        If the log group uses either a log-group level or account-level transformer, and you specify
         *        <code>true</code>, the subscription filter will be applied on the transformed version of the log
         *        events instead of the original ingested log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyOnTransformedLogs(Boolean applyOnTransformedLogs);

        /**
         * <p>
         * A filter expression that specifies which log events should be processed by this subscription filter based on
         * system fields such as source account and source region. Uses selection criteria syntax with operators like
         * <code>=</code>, <code>!=</code>, <code>AND</code>, <code>OR</code>, <code>IN</code>, <code>NOT IN</code>.
         * Example: <code>@aws.region NOT IN ["cn-north-1"]</code> or
         * <code>@aws.account = "123456789012" AND @aws.region = "us-east-1"</code>. Maximum length: 2000 characters.
         * </p>
         * 
         * @param fieldSelectionCriteria
         *        A filter expression that specifies which log events should be processed by this subscription filter
         *        based on system fields such as source account and source region. Uses selection criteria syntax with
         *        operators like <code>=</code>, <code>!=</code>, <code>AND</code>, <code>OR</code>, <code>IN</code>,
         *        <code>NOT IN</code>. Example: <code>@aws.region NOT IN ["cn-north-1"]</code> or
         *        <code>@aws.account = "123456789012" AND @aws.region = "us-east-1"</code>. Maximum length: 2000
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldSelectionCriteria(String fieldSelectionCriteria);

        /**
         * <p>
         * A list of system fields to include in the log events sent to the subscription destination. Valid values are
         * <code>@aws.account</code> and <code>@aws.region</code>. These fields provide source information for
         * centralized log data in the forwarded payload.
         * </p>
         * 
         * @param emitSystemFields
         *        A list of system fields to include in the log events sent to the subscription destination. Valid
         *        values are <code>@aws.account</code> and <code>@aws.region</code>. These fields provide source
         *        information for centralized log data in the forwarded payload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emitSystemFields(Collection<String> emitSystemFields);

        /**
         * <p>
         * A list of system fields to include in the log events sent to the subscription destination. Valid values are
         * <code>@aws.account</code> and <code>@aws.region</code>. These fields provide source information for
         * centralized log data in the forwarded payload.
         * </p>
         * 
         * @param emitSystemFields
         *        A list of system fields to include in the log events sent to the subscription destination. Valid
         *        values are <code>@aws.account</code> and <code>@aws.region</code>. These fields provide source
         *        information for centralized log data in the forwarded payload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emitSystemFields(String... emitSystemFields);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logGroupName;

        private String filterName;

        private String filterPattern;

        private String destinationArn;

        private String roleArn;

        private String distribution;

        private Boolean applyOnTransformedLogs;

        private String fieldSelectionCriteria;

        private List<String> emitSystemFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutSubscriptionFilterRequest model) {
            super(model);
            logGroupName(model.logGroupName);
            filterName(model.filterName);
            filterPattern(model.filterPattern);
            destinationArn(model.destinationArn);
            roleArn(model.roleArn);
            distribution(model.distribution);
            applyOnTransformedLogs(model.applyOnTransformedLogs);
            fieldSelectionCriteria(model.fieldSelectionCriteria);
            emitSystemFields(model.emitSystemFields);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getFilterName() {
            return filterName;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDistribution() {
            return distribution;
        }

        public final void setDistribution(String distribution) {
            this.distribution = distribution;
        }

        @Override
        public final Builder distribution(String distribution) {
            this.distribution = distribution;
            return this;
        }

        @Override
        public final Builder distribution(Distribution distribution) {
            this.distribution(distribution == null ? null : distribution.toString());
            return this;
        }

        public final Boolean getApplyOnTransformedLogs() {
            return applyOnTransformedLogs;
        }

        public final void setApplyOnTransformedLogs(Boolean applyOnTransformedLogs) {
            this.applyOnTransformedLogs = applyOnTransformedLogs;
        }

        @Override
        public final Builder applyOnTransformedLogs(Boolean applyOnTransformedLogs) {
            this.applyOnTransformedLogs = applyOnTransformedLogs;
            return this;
        }

        public final String getFieldSelectionCriteria() {
            return fieldSelectionCriteria;
        }

        public final void setFieldSelectionCriteria(String fieldSelectionCriteria) {
            this.fieldSelectionCriteria = fieldSelectionCriteria;
        }

        @Override
        public final Builder fieldSelectionCriteria(String fieldSelectionCriteria) {
            this.fieldSelectionCriteria = fieldSelectionCriteria;
            return this;
        }

        public final Collection<String> getEmitSystemFields() {
            if (emitSystemFields instanceof SdkAutoConstructList) {
                return null;
            }
            return emitSystemFields;
        }

        public final void setEmitSystemFields(Collection<String> emitSystemFields) {
            this.emitSystemFields = EmitSystemFieldsCopier.copy(emitSystemFields);
        }

        @Override
        public final Builder emitSystemFields(Collection<String> emitSystemFields) {
            this.emitSystemFields = EmitSystemFieldsCopier.copy(emitSystemFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emitSystemFields(String... emitSystemFields) {
            emitSystemFields(Arrays.asList(emitSystemFields));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSubscriptionFilterRequest build() {
            return new PutSubscriptionFilterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
