/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogStream;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogStreamsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLogStreamsResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeLogStreamsResponse> {
    private static final SdkField<List<LogStream>> LOG_STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logStreams").getter(DescribeLogStreamsResponse.getter(DescribeLogStreamsResponse::logStreams)).setter(DescribeLogStreamsResponse.setter(Builder::logStreams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogStream::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeLogStreamsResponse.getter(DescribeLogStreamsResponse::nextToken)).setter(DescribeLogStreamsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_STREAMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("logStreams", LOG_STREAMS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<LogStream> logStreams;
    private final String nextToken;

    private DescribeLogStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.logStreams = builder.logStreams;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLogStreams() {
        return this.logStreams != null && !(this.logStreams instanceof SdkAutoConstructList);
    }

    public final List<LogStream> logStreams() {
        return this.logStreams;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogStreams() ? this.logStreams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogStreamsResponse)) {
            return false;
        }
        DescribeLogStreamsResponse other = (DescribeLogStreamsResponse)((Object)obj);
        return this.hasLogStreams() == other.hasLogStreams() && Objects.equals(this.logStreams(), other.logStreams()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLogStreamsResponse").add("LogStreams", this.hasLogStreams() ? this.logStreams() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logStreams": {
                return Optional.ofNullable(clazz.cast(this.logStreams()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLogStreamsResponse, T> g) {
        return obj -> g.apply((DescribeLogStreamsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<LogStream> logStreams = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogStreamsResponse model) {
            super(model);
            this.logStreams(model.logStreams);
            this.nextToken(model.nextToken);
        }

        public final List<LogStream.Builder> getLogStreams() {
            List<LogStream.Builder> result = LogStreamsCopier.copyToBuilder(this.logStreams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogStreams(Collection<LogStream.BuilderImpl> logStreams) {
            this.logStreams = LogStreamsCopier.copyFromBuilder(logStreams);
        }

        @Override
        public final Builder logStreams(Collection<LogStream> logStreams) {
            this.logStreams = LogStreamsCopier.copy(logStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreams(LogStream ... logStreams) {
            this.logStreams(Arrays.asList(logStreams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreams(Consumer<LogStream.Builder> ... logStreams) {
            this.logStreams(Stream.of(logStreams).map(c -> (LogStream)((LogStream.Builder)LogStream.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeLogStreamsResponse build() {
            return new DescribeLogStreamsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLogStreamsResponse> {
        public Builder logStreams(Collection<LogStream> var1);

        public Builder logStreams(LogStream ... var1);

        public Builder logStreams(Consumer<LogStream.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

