/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.PolicyType;
import software.amazon.awssdk.services.cloudwatchlogs.model.Scope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountPolicy> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyName").getter(AccountPolicy.getter(AccountPolicy::policyName)).setter(AccountPolicy.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyDocument").getter(AccountPolicy.getter(AccountPolicy::policyDocument)).setter(AccountPolicy.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()}).build();
    private static final SdkField<Long> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastUpdatedTime").getter(AccountPolicy.getter(AccountPolicy::lastUpdatedTime)).setter(AccountPolicy.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyType").getter(AccountPolicy.getter(AccountPolicy::policyTypeAsString)).setter(AccountPolicy.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scope").getter(AccountPolicy.getter(AccountPolicy::scopeAsString)).setter(AccountPolicy.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final SdkField<String> SELECTION_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("selectionCriteria").getter(AccountPolicy.getter(AccountPolicy::selectionCriteria)).setter(AccountPolicy.setter(Builder::selectionCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectionCriteria").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(AccountPolicy.getter(AccountPolicy::accountId)).setter(AccountPolicy.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD, POLICY_DOCUMENT_FIELD, LAST_UPDATED_TIME_FIELD, POLICY_TYPE_FIELD, SCOPE_FIELD, SELECTION_CRITERIA_FIELD, ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String policyName;
    private final String policyDocument;
    private final Long lastUpdatedTime;
    private final String policyType;
    private final String scope;
    private final String selectionCriteria;
    private final String accountId;

    private AccountPolicy(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.policyType = builder.policyType;
        this.scope = builder.scope;
        this.selectionCriteria = builder.selectionCriteria;
        this.accountId = builder.accountId;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final Long lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public final Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final String selectionCriteria() {
        return this.selectionCriteria;
    }

    public final String accountId() {
        return this.accountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountPolicy)) {
            return false;
        }
        AccountPolicy other = (AccountPolicy)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.selectionCriteria(), other.selectionCriteria()) && Objects.equals(this.accountId(), other.accountId());
    }

    public final String toString() {
        return ToString.builder((String)"AccountPolicy").add("PolicyName", (Object)this.policyName()).add("PolicyDocument", (Object)this.policyDocument()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("PolicyType", (Object)this.policyTypeAsString()).add("Scope", (Object)this.scopeAsString()).add("SelectionCriteria", (Object)this.selectionCriteria()).add("AccountId", (Object)this.accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "policyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "policyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "selectionCriteria": {
                return Optional.ofNullable(clazz.cast(this.selectionCriteria()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyName", POLICY_NAME_FIELD);
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("policyType", POLICY_TYPE_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("selectionCriteria", SELECTION_CRITERIA_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountPolicy, T> g) {
        return obj -> g.apply((AccountPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private String policyDocument;
        private Long lastUpdatedTime;
        private String policyType;
        private String scope;
        private String selectionCriteria;
        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountPolicy model) {
            this.policyName(model.policyName);
            this.policyDocument(model.policyDocument);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.policyType(model.policyType);
            this.scope(model.scope);
            this.selectionCriteria(model.selectionCriteria);
            this.accountId(model.accountId);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final Long getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getSelectionCriteria() {
            return this.selectionCriteria;
        }

        public final void setSelectionCriteria(String selectionCriteria) {
            this.selectionCriteria = selectionCriteria;
        }

        @Override
        public final Builder selectionCriteria(String selectionCriteria) {
            this.selectionCriteria = selectionCriteria;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public AccountPolicy build() {
            return new AccountPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountPolicy> {
        public Builder policyName(String var1);

        public Builder policyDocument(String var1);

        public Builder lastUpdatedTime(Long var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);

        public Builder selectionCriteria(String var1);

        public Builder accountId(String var1);
    }
}

