/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.FlattenedElement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListToMap
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListToMap> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(ListToMap.getter(ListToMap::source)).setter(ListToMap.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(ListToMap.getter(ListToMap::key)).setter(ListToMap.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<String> VALUE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("valueKey").getter(ListToMap.getter(ListToMap::valueKey)).setter(ListToMap.setter(Builder::valueKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueKey").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("target").getter(ListToMap.getter(ListToMap::target)).setter(ListToMap.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<Boolean> FLATTEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("flatten").getter(ListToMap.getter(ListToMap::flatten)).setter(ListToMap.setter(Builder::flatten)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flatten").build()}).build();
    private static final SdkField<String> FLATTENED_ELEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flattenedElement").getter(ListToMap.getter(ListToMap::flattenedElementAsString)).setter(ListToMap.setter(Builder::flattenedElement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flattenedElement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, KEY_FIELD, VALUE_KEY_FIELD, TARGET_FIELD, FLATTEN_FIELD, FLATTENED_ELEMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("source", SOURCE_FIELD);
            this.put("key", KEY_FIELD);
            this.put("valueKey", VALUE_KEY_FIELD);
            this.put("target", TARGET_FIELD);
            this.put("flatten", FLATTEN_FIELD);
            this.put("flattenedElement", FLATTENED_ELEMENT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String source;
    private final String key;
    private final String valueKey;
    private final String target;
    private final Boolean flatten;
    private final String flattenedElement;

    private ListToMap(BuilderImpl builder) {
        this.source = builder.source;
        this.key = builder.key;
        this.valueKey = builder.valueKey;
        this.target = builder.target;
        this.flatten = builder.flatten;
        this.flattenedElement = builder.flattenedElement;
    }

    public final String source() {
        return this.source;
    }

    public final String key() {
        return this.key;
    }

    public final String valueKey() {
        return this.valueKey;
    }

    public final String target() {
        return this.target;
    }

    public final Boolean flatten() {
        return this.flatten;
    }

    public final FlattenedElement flattenedElement() {
        return FlattenedElement.fromValue(this.flattenedElement);
    }

    public final String flattenedElementAsString() {
        return this.flattenedElement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.flatten());
        hashCode = 31 * hashCode + Objects.hashCode(this.flattenedElementAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListToMap)) {
            return false;
        }
        ListToMap other = (ListToMap)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.valueKey(), other.valueKey()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.flatten(), other.flatten()) && Objects.equals(this.flattenedElementAsString(), other.flattenedElementAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListToMap").add("Source", (Object)this.source()).add("Key", (Object)this.key()).add("ValueKey", (Object)this.valueKey()).add("Target", (Object)this.target()).add("Flatten", (Object)this.flatten()).add("FlattenedElement", (Object)this.flattenedElementAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "valueKey": {
                return Optional.ofNullable(clazz.cast(this.valueKey()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "flatten": {
                return Optional.ofNullable(clazz.cast(this.flatten()));
            }
            case "flattenedElement": {
                return Optional.ofNullable(clazz.cast(this.flattenedElementAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListToMap, T> g) {
        return obj -> g.apply((ListToMap)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String source;
        private String key;
        private String valueKey;
        private String target;
        private Boolean flatten;
        private String flattenedElement;

        private BuilderImpl() {
        }

        private BuilderImpl(ListToMap model) {
            this.source(model.source);
            this.key(model.key);
            this.valueKey(model.valueKey);
            this.target(model.target);
            this.flatten(model.flatten);
            this.flattenedElement(model.flattenedElement);
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValueKey() {
            return this.valueKey;
        }

        public final void setValueKey(String valueKey) {
            this.valueKey = valueKey;
        }

        @Override
        public final Builder valueKey(String valueKey) {
            this.valueKey = valueKey;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final Boolean getFlatten() {
            return this.flatten;
        }

        public final void setFlatten(Boolean flatten) {
            this.flatten = flatten;
        }

        @Override
        public final Builder flatten(Boolean flatten) {
            this.flatten = flatten;
            return this;
        }

        public final String getFlattenedElement() {
            return this.flattenedElement;
        }

        public final void setFlattenedElement(String flattenedElement) {
            this.flattenedElement = flattenedElement;
        }

        @Override
        public final Builder flattenedElement(String flattenedElement) {
            this.flattenedElement = flattenedElement;
            return this;
        }

        @Override
        public final Builder flattenedElement(FlattenedElement flattenedElement) {
            this.flattenedElement(flattenedElement == null ? null : flattenedElement.toString());
            return this;
        }

        public ListToMap build() {
            return new ListToMap(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListToMap> {
        public Builder source(String var1);

        public Builder key(String var1);

        public Builder valueKey(String var1);

        public Builder target(String var1);

        public Builder flatten(Boolean var1);

        public Builder flattenedElement(String var1);

        public Builder flattenedElement(FlattenedElement var1);
    }
}

