/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClientBuilder;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsServiceClientConfiguration;
import software.amazon.awssdk.services.cloudwatchlogs.DefaultCloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.DefaultCloudWatchLogsBaseClientBuilder;
import software.amazon.awssdk.services.cloudwatchlogs.endpoints.CloudWatchLogsEndpointProvider;

@SdkInternalApi
final class DefaultCloudWatchLogsAsyncClientBuilder
extends DefaultCloudWatchLogsBaseClientBuilder<CloudWatchLogsAsyncClientBuilder, CloudWatchLogsAsyncClient>
implements CloudWatchLogsAsyncClientBuilder {
    DefaultCloudWatchLogsAsyncClientBuilder() {
    }

    @Override
    public DefaultCloudWatchLogsAsyncClientBuilder endpointProvider(CloudWatchLogsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudWatchLogsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCloudWatchLogsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CloudWatchLogsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCloudWatchLogsAsyncClient client = new DefaultCloudWatchLogsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CloudWatchLogsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CloudWatchLogsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

