/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDestinationPolicyRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, PutDestinationPolicyRequest> {
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationName").getter(PutDestinationPolicyRequest.getter(PutDestinationPolicyRequest::destinationName)).setter(PutDestinationPolicyRequest.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationName").build()}).build();
    private static final SdkField<String> ACCESS_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessPolicy").getter(PutDestinationPolicyRequest.getter(PutDestinationPolicyRequest::accessPolicy)).setter(PutDestinationPolicyRequest.setter(Builder::accessPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_NAME_FIELD, ACCESS_POLICY_FIELD));
    private final String destinationName;
    private final String accessPolicy;

    private PutDestinationPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.destinationName = builder.destinationName;
        this.accessPolicy = builder.accessPolicy;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public final String accessPolicy() {
        return this.accessPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDestinationPolicyRequest)) {
            return false;
        }
        PutDestinationPolicyRequest other = (PutDestinationPolicyRequest)((Object)obj);
        return Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.accessPolicy(), other.accessPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"PutDestinationPolicyRequest").add("DestinationName", (Object)this.destinationName()).add("AccessPolicy", (Object)this.accessPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "accessPolicy": {
                return Optional.ofNullable(clazz.cast(this.accessPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDestinationPolicyRequest, T> g) {
        return obj -> g.apply((PutDestinationPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String destinationName;
        private String accessPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDestinationPolicyRequest model) {
            super(model);
            this.destinationName(model.destinationName);
            this.accessPolicy(model.accessPolicy);
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        @Transient
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getAccessPolicy() {
            return this.accessPolicy;
        }

        public final void setAccessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
        }

        @Override
        @Transient
        public final Builder accessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDestinationPolicyRequest build() {
            return new PutDestinationPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDestinationPolicyRequest> {
        public Builder destinationName(String var1);

        public Builder accessPolicy(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

