/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.AssociateKmsKeyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.AssociateKmsKeyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CancelExportTaskRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CancelExportTaskResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsException;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateExportTaskRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateExportTaskResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DataAlreadyAcceptedException;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogStreamRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogStreamResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteMetricFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteMetricFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteQueryDefinitionRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteQueryDefinitionResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteRetentionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteRetentionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteSubscriptionFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteSubscriptionFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueriesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueriesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueryDefinitionsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueryDefinitionsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeResourcePoliciesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeResourcePoliciesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DisassociateKmsKeyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DisassociateKmsKeyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogGroupFieldsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogGroupFieldsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogRecordRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogRecordResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.InvalidOperationException;
import software.amazon.awssdk.services.cloudwatchlogs.model.InvalidParameterException;
import software.amazon.awssdk.services.cloudwatchlogs.model.InvalidSequenceTokenException;
import software.amazon.awssdk.services.cloudwatchlogs.model.LimitExceededException;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListTagsLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListTagsLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.MalformedQueryException;
import software.amazon.awssdk.services.cloudwatchlogs.model.OperationAbortedException;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutMetricFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutMetricFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutQueryDefinitionRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutQueryDefinitionResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutRetentionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutRetentionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutSubscriptionFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutSubscriptionFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudwatchlogs.model.ServiceUnavailableException;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartQueryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.StopQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.StopQueryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestMetricFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestMetricFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.UnrecognizedClientException;
import software.amazon.awssdk.services.cloudwatchlogs.model.UntagLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UntagLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDestinationsIterable;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeLogGroupsIterable;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeLogStreamsIterable;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeMetricFiltersIterable;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeSubscriptionFiltersIterable;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.FilterLogEventsIterable;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.GetLogEventsIterable;
import software.amazon.awssdk.services.cloudwatchlogs.transform.AssociateKmsKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CancelExportTaskRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CreateExportTaskRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CreateLogGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CreateLogStreamRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteDestinationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteLogGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteLogStreamRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteMetricFilterRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteQueryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteRetentionPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteSubscriptionFilterRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeDestinationsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeExportTasksRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeLogGroupsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeLogStreamsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeMetricFiltersRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeQueriesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeQueryDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeResourcePoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeSubscriptionFiltersRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DisassociateKmsKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.FilterLogEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetLogEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetLogGroupFieldsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetLogRecordRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetQueryResultsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListTagsLogGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutDestinationPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutDestinationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutLogEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutMetricFilterRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutQueryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutRetentionPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutSubscriptionFilterRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.StartQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.StopQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.TagLogGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.TestMetricFilterRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.UntagLogGroupRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCloudWatchLogsClient
implements CloudWatchLogsClient {
    private static final Logger log = Logger.loggerFor(DefaultCloudWatchLogsClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudWatchLogsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "logs";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateKmsKeyResponse associateKmsKey(AssociateKmsKeyRequest associateKmsKeyRequest) throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateKmsKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, associateKmsKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateKmsKey");
            AssociateKmsKeyResponse associateKmsKeyResponse = (AssociateKmsKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateKmsKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateKmsKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateKmsKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateKmsKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$associateKmsKey$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelExportTaskResponse cancelExportTask(CancelExportTaskRequest cancelExportTaskRequest) throws InvalidParameterException, ResourceNotFoundException, InvalidOperationException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelExportTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, cancelExportTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelExportTask");
            CancelExportTaskResponse cancelExportTaskResponse = (CancelExportTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelExportTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelExportTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelExportTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelExportTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$cancelExportTask$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateExportTaskResponse createExportTask(CreateExportTaskRequest createExportTaskRequest) throws InvalidParameterException, LimitExceededException, OperationAbortedException, ServiceUnavailableException, ResourceNotFoundException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateExportTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, createExportTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateExportTask");
            CreateExportTaskResponse createExportTaskResponse = (CreateExportTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateExportTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createExportTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateExportTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createExportTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$createExportTask$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLogGroupResponse createLogGroup(CreateLogGroupRequest createLogGroupRequest) throws InvalidParameterException, ResourceAlreadyExistsException, LimitExceededException, OperationAbortedException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLogGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, createLogGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLogGroup");
            CreateLogGroupResponse createLogGroupResponse = (CreateLogGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLogGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLogGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLogGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLogGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$createLogGroup$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLogStreamResponse createLogStream(CreateLogStreamRequest createLogStreamRequest) throws InvalidParameterException, ResourceAlreadyExistsException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLogStreamResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, createLogStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLogStream");
            CreateLogStreamResponse createLogStreamResponse = (CreateLogStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLogStream").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLogStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLogStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLogStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$createLogStream$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDestinationResponse deleteDestination(DeleteDestinationRequest deleteDestinationRequest) throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, deleteDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDestination");
            DeleteDestinationResponse deleteDestinationResponse = (DeleteDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$deleteDestination$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLogGroupResponse deleteLogGroup(DeleteLogGroupRequest deleteLogGroupRequest) throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLogGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, deleteLogGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLogGroup");
            DeleteLogGroupResponse deleteLogGroupResponse = (DeleteLogGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLogGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLogGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLogGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLogGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$deleteLogGroup$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLogStreamResponse deleteLogStream(DeleteLogStreamRequest deleteLogStreamRequest) throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLogStreamResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, deleteLogStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLogStream");
            DeleteLogStreamResponse deleteLogStreamResponse = (DeleteLogStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLogStream").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLogStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLogStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLogStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$deleteLogStream$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMetricFilterResponse deleteMetricFilter(DeleteMetricFilterRequest deleteMetricFilterRequest) throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMetricFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, deleteMetricFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMetricFilter");
            DeleteMetricFilterResponse deleteMetricFilterResponse = (DeleteMetricFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMetricFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMetricFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMetricFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMetricFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$deleteMetricFilter$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteQueryDefinitionResponse deleteQueryDefinition(DeleteQueryDefinitionRequest deleteQueryDefinitionRequest) throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteQueryDefinitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, deleteQueryDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteQueryDefinition");
            DeleteQueryDefinitionResponse deleteQueryDefinitionResponse = (DeleteQueryDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteQueryDefinition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteQueryDefinitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteQueryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteQueryDefinitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$deleteQueryDefinition$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            DeleteResourcePolicyResponse deleteResourcePolicyResponse = (DeleteResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$deleteResourcePolicy$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRetentionPolicyResponse deleteRetentionPolicy(DeleteRetentionPolicyRequest deleteRetentionPolicyRequest) throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRetentionPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, deleteRetentionPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRetentionPolicy");
            DeleteRetentionPolicyResponse deleteRetentionPolicyResponse = (DeleteRetentionPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRetentionPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRetentionPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRetentionPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRetentionPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$deleteRetentionPolicy$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSubscriptionFilterResponse deleteSubscriptionFilter(DeleteSubscriptionFilterRequest deleteSubscriptionFilterRequest) throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSubscriptionFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, deleteSubscriptionFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSubscriptionFilter");
            DeleteSubscriptionFilterResponse deleteSubscriptionFilterResponse = (DeleteSubscriptionFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSubscriptionFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSubscriptionFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSubscriptionFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSubscriptionFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$deleteSubscriptionFilter$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDestinationsResponse describeDestinations(DescribeDestinationsRequest describeDestinationsRequest) throws InvalidParameterException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDestinationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, describeDestinationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDestinations");
            DescribeDestinationsResponse describeDestinationsResponse = (DescribeDestinationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDestinations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDestinationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDestinationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDestinationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$describeDestinations$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDestinationsIterable describeDestinationsPaginator(DescribeDestinationsRequest describeDestinationsRequest) throws InvalidParameterException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        return new DescribeDestinationsIterable(this, this.applyPaginatorUserAgent(describeDestinationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeExportTasksResponse describeExportTasks(DescribeExportTasksRequest describeExportTasksRequest) throws InvalidParameterException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExportTasksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, describeExportTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExportTasks");
            DescribeExportTasksResponse describeExportTasksResponse = (DescribeExportTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExportTasks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeExportTasksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeExportTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeExportTasksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$describeExportTasks$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLogGroupsResponse describeLogGroups(DescribeLogGroupsRequest describeLogGroupsRequest) throws InvalidParameterException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLogGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, describeLogGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLogGroups");
            DescribeLogGroupsResponse describeLogGroupsResponse = (DescribeLogGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLogGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLogGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLogGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeLogGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$describeLogGroups$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeLogGroupsIterable describeLogGroupsPaginator(DescribeLogGroupsRequest describeLogGroupsRequest) throws InvalidParameterException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        return new DescribeLogGroupsIterable(this, this.applyPaginatorUserAgent(describeLogGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLogStreamsResponse describeLogStreams(DescribeLogStreamsRequest describeLogStreamsRequest) throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLogStreamsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, describeLogStreamsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLogStreams");
            DescribeLogStreamsResponse describeLogStreamsResponse = (DescribeLogStreamsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLogStreams").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLogStreamsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLogStreamsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeLogStreamsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$describeLogStreams$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeLogStreamsIterable describeLogStreamsPaginator(DescribeLogStreamsRequest describeLogStreamsRequest) throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        return new DescribeLogStreamsIterable(this, this.applyPaginatorUserAgent(describeLogStreamsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMetricFiltersResponse describeMetricFilters(DescribeMetricFiltersRequest describeMetricFiltersRequest) throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMetricFiltersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, describeMetricFiltersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMetricFilters");
            DescribeMetricFiltersResponse describeMetricFiltersResponse = (DescribeMetricFiltersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMetricFilters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMetricFiltersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMetricFiltersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMetricFiltersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$describeMetricFilters$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeMetricFiltersIterable describeMetricFiltersPaginator(DescribeMetricFiltersRequest describeMetricFiltersRequest) throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        return new DescribeMetricFiltersIterable(this, this.applyPaginatorUserAgent(describeMetricFiltersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeQueriesResponse describeQueries(DescribeQueriesRequest describeQueriesRequest) throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeQueriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, describeQueriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeQueries");
            DescribeQueriesResponse describeQueriesResponse = (DescribeQueriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeQueries").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeQueriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeQueriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeQueriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$describeQueries$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeQueryDefinitionsResponse describeQueryDefinitions(DescribeQueryDefinitionsRequest describeQueryDefinitionsRequest) throws InvalidParameterException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeQueryDefinitionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, describeQueryDefinitionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeQueryDefinitions");
            DescribeQueryDefinitionsResponse describeQueryDefinitionsResponse = (DescribeQueryDefinitionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeQueryDefinitions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeQueryDefinitionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeQueryDefinitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeQueryDefinitionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$describeQueryDefinitions$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeResourcePoliciesResponse describeResourcePolicies(DescribeResourcePoliciesRequest describeResourcePoliciesRequest) throws InvalidParameterException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourcePoliciesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, describeResourcePoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResourcePolicies");
            DescribeResourcePoliciesResponse describeResourcePoliciesResponse = (DescribeResourcePoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResourcePolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeResourcePoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeResourcePoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeResourcePoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$describeResourcePolicies$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSubscriptionFiltersResponse describeSubscriptionFilters(DescribeSubscriptionFiltersRequest describeSubscriptionFiltersRequest) throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSubscriptionFiltersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, describeSubscriptionFiltersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSubscriptionFilters");
            DescribeSubscriptionFiltersResponse describeSubscriptionFiltersResponse = (DescribeSubscriptionFiltersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSubscriptionFilters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSubscriptionFiltersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSubscriptionFiltersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSubscriptionFiltersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$describeSubscriptionFilters$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeSubscriptionFiltersIterable describeSubscriptionFiltersPaginator(DescribeSubscriptionFiltersRequest describeSubscriptionFiltersRequest) throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        return new DescribeSubscriptionFiltersIterable(this, this.applyPaginatorUserAgent(describeSubscriptionFiltersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateKmsKeyResponse disassociateKmsKey(DisassociateKmsKeyRequest disassociateKmsKeyRequest) throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateKmsKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, disassociateKmsKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateKmsKey");
            DisassociateKmsKeyResponse disassociateKmsKeyResponse = (DisassociateKmsKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateKmsKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateKmsKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateKmsKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateKmsKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$disassociateKmsKey$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterLogEventsResponse filterLogEvents(FilterLogEventsRequest filterLogEventsRequest) throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, FilterLogEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, filterLogEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"FilterLogEvents");
            FilterLogEventsResponse filterLogEventsResponse = (FilterLogEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("FilterLogEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)filterLogEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new FilterLogEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return filterLogEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$filterLogEvents$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public FilterLogEventsIterable filterLogEventsPaginator(FilterLogEventsRequest filterLogEventsRequest) throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        return new FilterLogEventsIterable(this, this.applyPaginatorUserAgent(filterLogEventsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLogEventsResponse getLogEvents(GetLogEventsRequest getLogEventsRequest) throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLogEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, getLogEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLogEvents");
            GetLogEventsResponse getLogEventsResponse = (GetLogEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLogEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLogEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLogEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLogEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$getLogEvents$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetLogEventsIterable getLogEventsPaginator(GetLogEventsRequest getLogEventsRequest) throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        return new GetLogEventsIterable(this, this.applyPaginatorUserAgent(getLogEventsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLogGroupFieldsResponse getLogGroupFields(GetLogGroupFieldsRequest getLogGroupFieldsRequest) throws InvalidParameterException, LimitExceededException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLogGroupFieldsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, getLogGroupFieldsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLogGroupFields");
            GetLogGroupFieldsResponse getLogGroupFieldsResponse = (GetLogGroupFieldsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLogGroupFields").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLogGroupFieldsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLogGroupFieldsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLogGroupFieldsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$getLogGroupFields$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLogRecordResponse getLogRecord(GetLogRecordRequest getLogRecordRequest) throws InvalidParameterException, LimitExceededException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLogRecordResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, getLogRecordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLogRecord");
            GetLogRecordResponse getLogRecordResponse = (GetLogRecordResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLogRecord").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLogRecordRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLogRecordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLogRecordResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$getLogRecord$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueryResultsResponse getQueryResults(GetQueryResultsRequest getQueryResultsRequest) throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryResultsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, getQueryResultsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueryResults");
            GetQueryResultsResponse getQueryResultsResponse = (GetQueryResultsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryResults").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQueryResultsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetQueryResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getQueryResultsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$getQueryResults$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsLogGroupResponse listTagsLogGroup(ListTagsLogGroupRequest listTagsLogGroupRequest) throws ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsLogGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, listTagsLogGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsLogGroup");
            ListTagsLogGroupResponse listTagsLogGroupResponse = (ListTagsLogGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsLogGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsLogGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsLogGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsLogGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$listTagsLogGroup$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutDestinationResponse putDestination(PutDestinationRequest putDestinationRequest) throws InvalidParameterException, OperationAbortedException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, putDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDestination");
            PutDestinationResponse putDestinationResponse = (PutDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$putDestination$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutDestinationPolicyResponse putDestinationPolicy(PutDestinationPolicyRequest putDestinationPolicyRequest) throws InvalidParameterException, OperationAbortedException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDestinationPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, putDestinationPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDestinationPolicy");
            PutDestinationPolicyResponse putDestinationPolicyResponse = (PutDestinationPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDestinationPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDestinationPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutDestinationPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putDestinationPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$putDestinationPolicy$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutLogEventsResponse putLogEvents(PutLogEventsRequest putLogEventsRequest) throws InvalidParameterException, InvalidSequenceTokenException, DataAlreadyAcceptedException, ResourceNotFoundException, ServiceUnavailableException, UnrecognizedClientException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutLogEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, putLogEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutLogEvents");
            PutLogEventsResponse putLogEventsResponse = (PutLogEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutLogEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putLogEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutLogEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putLogEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$putLogEvents$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutMetricFilterResponse putMetricFilter(PutMetricFilterRequest putMetricFilterRequest) throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, LimitExceededException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutMetricFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, putMetricFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutMetricFilter");
            PutMetricFilterResponse putMetricFilterResponse = (PutMetricFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutMetricFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putMetricFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutMetricFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putMetricFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$putMetricFilter$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutQueryDefinitionResponse putQueryDefinition(PutQueryDefinitionRequest putQueryDefinitionRequest) throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutQueryDefinitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, putQueryDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutQueryDefinition");
            PutQueryDefinitionResponse putQueryDefinitionResponse = (PutQueryDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutQueryDefinition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putQueryDefinitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutQueryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putQueryDefinitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$putQueryDefinition$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) throws InvalidParameterException, LimitExceededException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            PutResourcePolicyResponse putResourcePolicyResponse = (PutResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$putResourcePolicy$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRetentionPolicyResponse putRetentionPolicy(PutRetentionPolicyRequest putRetentionPolicyRequest) throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRetentionPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, putRetentionPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRetentionPolicy");
            PutRetentionPolicyResponse putRetentionPolicyResponse = (PutRetentionPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRetentionPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putRetentionPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutRetentionPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putRetentionPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$putRetentionPolicy$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutSubscriptionFilterResponse putSubscriptionFilter(PutSubscriptionFilterRequest putSubscriptionFilterRequest) throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, LimitExceededException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutSubscriptionFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, putSubscriptionFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutSubscriptionFilter");
            PutSubscriptionFilterResponse putSubscriptionFilterResponse = (PutSubscriptionFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutSubscriptionFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putSubscriptionFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutSubscriptionFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putSubscriptionFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$putSubscriptionFilter$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartQueryResponse startQuery(StartQueryRequest startQueryRequest) throws MalformedQueryException, InvalidParameterException, LimitExceededException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, startQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartQuery");
            StartQueryResponse startQueryResponse = (StartQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$startQuery$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopQueryResponse stopQuery(StopQueryRequest stopQueryRequest) throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, stopQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopQuery");
            StopQueryResponse stopQueryResponse = (StopQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$stopQuery$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagLogGroupResponse tagLogGroup(TagLogGroupRequest tagLogGroupRequest) throws ResourceNotFoundException, InvalidParameterException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagLogGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, tagLogGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagLogGroup");
            TagLogGroupResponse tagLogGroupResponse = (TagLogGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagLogGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagLogGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagLogGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagLogGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$tagLogGroup$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestMetricFilterResponse testMetricFilter(TestMetricFilterRequest testMetricFilterRequest) throws InvalidParameterException, ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestMetricFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, testMetricFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestMetricFilter");
            TestMetricFilterResponse testMetricFilterResponse = (TestMetricFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestMetricFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)testMetricFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TestMetricFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return testMetricFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$testMetricFilter$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagLogGroupResponse untagLogGroup(UntagLogGroupRequest untagLogGroupRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagLogGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchLogsClient.resolveMetricPublishers(this.clientConfiguration, untagLogGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagLogGroup");
            UntagLogGroupResponse untagLogGroupResponse = (UntagLogGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagLogGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagLogGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagLogGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagLogGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchLogsClient.lambda$untagLogGroup$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudWatchLogsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOperationException").exceptionBuilderSupplier(InvalidOperationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationAbortedException").exceptionBuilderSupplier(OperationAbortedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").exceptionBuilderSupplier(UnrecognizedClientException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MalformedQueryException").exceptionBuilderSupplier(MalformedQueryException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CloudWatchLogsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.16.56").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudWatchLogsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$untagLogGroup$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$testMetricFilter$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagLogGroup$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopQuery$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startQuery$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putSubscriptionFilter$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putRetentionPolicy$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putQueryDefinition$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putMetricFilter$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putLogEvents$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putDestinationPolicy$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putDestination$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsLogGroup$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getQueryResults$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLogRecord$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLogGroupFields$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLogEvents$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$filterLogEvents$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateKmsKey$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSubscriptionFilters$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeResourcePolicies$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeQueryDefinitions$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeQueries$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMetricFilters$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLogStreams$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLogGroups$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeExportTasks$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDestinations$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSubscriptionFilter$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRetentionPolicy$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteQueryDefinition$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMetricFilter$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLogStream$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLogGroup$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDestination$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLogStream$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLogGroup$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createExportTask$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelExportTask$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateKmsKey$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

