/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroupNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryDefinition> {
    private static final SdkField<String> QUERY_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryDefinitionId").getter(QueryDefinition.getter(QueryDefinition::queryDefinitionId)).setter(QueryDefinition.setter(Builder::queryDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryDefinitionId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(QueryDefinition.getter(QueryDefinition::name)).setter(QueryDefinition.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryString").getter(QueryDefinition.getter(QueryDefinition::queryString)).setter(QueryDefinition.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastModified").getter(QueryDefinition.getter(QueryDefinition::lastModified)).setter(QueryDefinition.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build()}).build();
    private static final SdkField<List<String>> LOG_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logGroupNames").getter(QueryDefinition.getter(QueryDefinition::logGroupNames)).setter(QueryDefinition.setter(Builder::logGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_DEFINITION_ID_FIELD, NAME_FIELD, QUERY_STRING_FIELD, LAST_MODIFIED_FIELD, LOG_GROUP_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String queryDefinitionId;
    private final String name;
    private final String queryString;
    private final Long lastModified;
    private final List<String> logGroupNames;

    private QueryDefinition(BuilderImpl builder) {
        this.queryDefinitionId = builder.queryDefinitionId;
        this.name = builder.name;
        this.queryString = builder.queryString;
        this.lastModified = builder.lastModified;
        this.logGroupNames = builder.logGroupNames;
    }

    public final String queryDefinitionId() {
        return this.queryDefinitionId;
    }

    public final String name() {
        return this.name;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final Long lastModified() {
        return this.lastModified;
    }

    public final boolean hasLogGroupNames() {
        return this.logGroupNames != null && !(this.logGroupNames instanceof SdkAutoConstructList);
    }

    public final List<String> logGroupNames() {
        return this.logGroupNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogGroupNames() ? this.logGroupNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryDefinition)) {
            return false;
        }
        QueryDefinition other = (QueryDefinition)obj;
        return Objects.equals(this.queryDefinitionId(), other.queryDefinitionId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.lastModified(), other.lastModified()) && this.hasLogGroupNames() == other.hasLogGroupNames() && Objects.equals(this.logGroupNames(), other.logGroupNames());
    }

    public final String toString() {
        return ToString.builder((String)"QueryDefinition").add("QueryDefinitionId", (Object)this.queryDefinitionId()).add("Name", (Object)this.name()).add("QueryString", (Object)this.queryString()).add("LastModified", (Object)this.lastModified()).add("LogGroupNames", this.hasLogGroupNames() ? this.logGroupNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queryDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.queryDefinitionId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "queryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "lastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "logGroupNames": {
                return Optional.ofNullable(clazz.cast(this.logGroupNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryDefinition, T> g) {
        return obj -> g.apply((QueryDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryDefinitionId;
        private String name;
        private String queryString;
        private Long lastModified;
        private List<String> logGroupNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryDefinition model) {
            this.queryDefinitionId(model.queryDefinitionId);
            this.name(model.name);
            this.queryString(model.queryString);
            this.lastModified(model.lastModified);
            this.logGroupNames(model.logGroupNames);
        }

        public final String getQueryDefinitionId() {
            return this.queryDefinitionId;
        }

        @Override
        public final Builder queryDefinitionId(String queryDefinitionId) {
            this.queryDefinitionId = queryDefinitionId;
            return this;
        }

        public final void setQueryDefinitionId(String queryDefinitionId) {
            this.queryDefinitionId = queryDefinitionId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final Long getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Long lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Long lastModified) {
            this.lastModified = lastModified;
        }

        public final Collection<String> getLogGroupNames() {
            if (this.logGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logGroupNames;
        }

        @Override
        public final Builder logGroupNames(Collection<String> logGroupNames) {
            this.logGroupNames = LogGroupNamesCopier.copy(logGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupNames(String ... logGroupNames) {
            this.logGroupNames(Arrays.asList(logGroupNames));
            return this;
        }

        public final void setLogGroupNames(Collection<String> logGroupNames) {
            this.logGroupNames = LogGroupNamesCopier.copy(logGroupNames);
        }

        public QueryDefinition build() {
            return new QueryDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryDefinition> {
        public Builder queryDefinitionId(String var1);

        public Builder name(String var1);

        public Builder queryString(String var1);

        public Builder lastModified(Long var1);

        public Builder logGroupNames(Collection<String> var1);

        public Builder logGroupNames(String ... var1);
    }
}

