/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeQueriesResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<DescribeQueriesResponse.Builder, DescribeQueriesResponse> {
    private static final SdkField<List<QueryInfo>> QUERIES_FIELD = SdkField
            .<List<QueryInfo>> builder(MarshallingType.LIST)
            .getter(getter(DescribeQueriesResponse::queries))
            .setter(setter(Builder::queries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeQueriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<QueryInfo> queries;

    private final String nextToken;

    private DescribeQueriesResponse(BuilderImpl builder) {
        super(builder);
        this.queries = builder.queries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Queries property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasQueries() {
        return queries != null && !(queries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of queries that match the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQueries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of queries that match the request.
     */
    public List<QueryInfo> queries() {
        return queries;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeQueriesResponse)) {
            return false;
        }
        DescribeQueriesResponse other = (DescribeQueriesResponse) obj;
        return Objects.equals(queries(), other.queries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeQueriesResponse").add("Queries", queries()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queries":
            return Optional.ofNullable(clazz.cast(queries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeQueriesResponse, T> g) {
        return obj -> g.apply((DescribeQueriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeQueriesResponse> {
        /**
         * <p>
         * The list of queries that match the request.
         * </p>
         * 
         * @param queries
         *        The list of queries that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queries(Collection<QueryInfo> queries);

        /**
         * <p>
         * The list of queries that match the request.
         * </p>
         * 
         * @param queries
         *        The list of queries that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queries(QueryInfo... queries);

        /**
         * <p>
         * The list of queries that match the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<QueryInfo>.Builder} avoiding the need to
         * create one manually via {@link List<QueryInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<QueryInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #queries(List<QueryInfo>)}.
         * 
         * @param queries
         *        a consumer that will call methods on {@link List<QueryInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queries(List<QueryInfo>)
         */
        Builder queries(Consumer<QueryInfo.Builder>... queries);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<QueryInfo> queries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeQueriesResponse model) {
            super(model);
            queries(model.queries);
            nextToken(model.nextToken);
        }

        public final Collection<QueryInfo.Builder> getQueries() {
            return queries != null ? queries.stream().map(QueryInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queries(Collection<QueryInfo> queries) {
            this.queries = QueryInfoListCopier.copy(queries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(QueryInfo... queries) {
            queries(Arrays.asList(queries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Consumer<QueryInfo.Builder>... queries) {
            queries(Stream.of(queries).map(c -> QueryInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQueries(Collection<QueryInfo.BuilderImpl> queries) {
            this.queries = QueryInfoListCopier.copyFromBuilder(queries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeQueriesResponse build() {
            return new DescribeQueriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
