/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMetricFiltersRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<DescribeMetricFiltersRequest.Builder, DescribeMetricFiltersRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMetricFiltersRequest::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<String> FILTER_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMetricFiltersRequest::filterNamePrefix)).setter(setter(Builder::filterNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterNamePrefix").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMetricFiltersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeMetricFiltersRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMetricFiltersRequest::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<String> METRIC_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMetricFiltersRequest::metricNamespace)).setter(setter(Builder::metricNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricNamespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            FILTER_NAME_PREFIX_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD, METRIC_NAME_FIELD, METRIC_NAMESPACE_FIELD));

    private final String logGroupName;

    private final String filterNamePrefix;

    private final String nextToken;

    private final Integer limit;

    private final String metricName;

    private final String metricNamespace;

    private DescribeMetricFiltersRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.filterNamePrefix = builder.filterNamePrefix;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
        this.metricName = builder.metricName;
        this.metricNamespace = builder.metricNamespace;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The prefix to match.
     * </p>
     * 
     * @return The prefix to match.
     */
    public String filterNamePrefix() {
        return filterNamePrefix;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
     * </p>
     * 
     * @return The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * Filters results to include only those with the specified metric name. If you include this parameter in your
     * request, you must also include the <code>metricNamespace</code> parameter.
     * </p>
     * 
     * @return Filters results to include only those with the specified metric name. If you include this parameter in
     *         your request, you must also include the <code>metricNamespace</code> parameter.
     */
    public String metricName() {
        return metricName;
    }

    /**
     * <p>
     * Filters results to include only those in the specified namespace. If you include this parameter in your request,
     * you must also include the <code>metricName</code> parameter.
     * </p>
     * 
     * @return Filters results to include only those in the specified namespace. If you include this parameter in your
     *         request, you must also include the <code>metricName</code> parameter.
     */
    public String metricNamespace() {
        return metricNamespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(filterNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(metricNamespace());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricFiltersRequest)) {
            return false;
        }
        DescribeMetricFiltersRequest other = (DescribeMetricFiltersRequest) obj;
        return Objects.equals(logGroupName(), other.logGroupName())
                && Objects.equals(filterNamePrefix(), other.filterNamePrefix()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(limit(), other.limit()) && Objects.equals(metricName(), other.metricName())
                && Objects.equals(metricNamespace(), other.metricNamespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeMetricFiltersRequest").add("LogGroupName", logGroupName())
                .add("FilterNamePrefix", filterNamePrefix()).add("NextToken", nextToken()).add("Limit", limit())
                .add("MetricName", metricName()).add("MetricNamespace", metricNamespace()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "filterNamePrefix":
            return Optional.ofNullable(clazz.cast(filterNamePrefix()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "metricNamespace":
            return Optional.ofNullable(clazz.cast(metricNamespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetricFiltersRequest, T> g) {
        return obj -> g.apply((DescribeMetricFiltersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMetricFiltersRequest> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The prefix to match.
         * </p>
         * 
         * @param filterNamePrefix
         *        The prefix to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterNamePrefix(String filterNamePrefix);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
         * </p>
         * 
         * @param limit
         *        The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * Filters results to include only those with the specified metric name. If you include this parameter in your
         * request, you must also include the <code>metricNamespace</code> parameter.
         * </p>
         * 
         * @param metricName
         *        Filters results to include only those with the specified metric name. If you include this parameter in
         *        your request, you must also include the <code>metricNamespace</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * Filters results to include only those in the specified namespace. If you include this parameter in your
         * request, you must also include the <code>metricName</code> parameter.
         * </p>
         * 
         * @param metricNamespace
         *        Filters results to include only those in the specified namespace. If you include this parameter in
         *        your request, you must also include the <code>metricName</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricNamespace(String metricNamespace);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logGroupName;

        private String filterNamePrefix;

        private String nextToken;

        private Integer limit;

        private String metricName;

        private String metricNamespace;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricFiltersRequest model) {
            super(model);
            logGroupName(model.logGroupName);
            filterNamePrefix(model.filterNamePrefix);
            nextToken(model.nextToken);
            limit(model.limit);
            metricName(model.metricName);
            metricNamespace(model.metricNamespace);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getFilterNamePrefix() {
            return filterNamePrefix;
        }

        @Override
        public final Builder filterNamePrefix(String filterNamePrefix) {
            this.filterNamePrefix = filterNamePrefix;
            return this;
        }

        public final void setFilterNamePrefix(String filterNamePrefix) {
            this.filterNamePrefix = filterNamePrefix;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getMetricNamespace() {
            return metricNamespace;
        }

        @Override
        public final Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        public final void setMetricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeMetricFiltersRequest build() {
            return new DescribeMetricFiltersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
