/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.SearchedLogStream;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SearchedLogStreamMarshaller {
    private static final MarshallingInfo<String> LOGSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logStreamName").isBinary(false).build();
    private static final MarshallingInfo<Boolean> SEARCHEDCOMPLETELY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("searchedCompletely").isBinary(false).build();
    private static final SearchedLogStreamMarshaller INSTANCE = new SearchedLogStreamMarshaller();

    private SearchedLogStreamMarshaller() {
    }

    public static SearchedLogStreamMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SearchedLogStream searchedLogStream, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)searchedLogStream, (String)"searchedLogStream");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)searchedLogStream.logStreamName(), LOGSTREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)searchedLogStream.searchedCompletely(), SEARCHEDCOMPLETELY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

