/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutMetricFilterRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutMetricFilterRequestModelMarshaller {
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupName").isBinary(false).build();
    private static final MarshallingInfo<String> FILTERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filterName").isBinary(false).build();
    private static final MarshallingInfo<String> FILTERPATTERN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filterPattern").isBinary(false).build();
    private static final MarshallingInfo<List> METRICTRANSFORMATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricTransformations").isBinary(false).build();
    private static final PutMetricFilterRequestModelMarshaller INSTANCE = new PutMetricFilterRequestModelMarshaller();

    private PutMetricFilterRequestModelMarshaller() {
    }

    public static PutMetricFilterRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutMetricFilterRequest putMetricFilterRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)putMetricFilterRequest), (String)"putMetricFilterRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)putMetricFilterRequest.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)putMetricFilterRequest.filterName(), FILTERNAME_BINDING);
            protocolMarshaller.marshall((Object)putMetricFilterRequest.filterPattern(), FILTERPATTERN_BINDING);
            protocolMarshaller.marshall(putMetricFilterRequest.metricTransformations(), METRICTRANSFORMATIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

