/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.OutputLogEvent;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OutputLogEventMarshaller {
    private static final MarshallingInfo<Long> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").isBinary(false).build();
    private static final MarshallingInfo<Long> INGESTIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ingestionTime").isBinary(false).build();
    private static final OutputLogEventMarshaller INSTANCE = new OutputLogEventMarshaller();

    private OutputLogEventMarshaller() {
    }

    public static OutputLogEventMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputLogEvent outputLogEvent, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)outputLogEvent, (String)"outputLogEvent");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)outputLogEvent.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)outputLogEvent.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)outputLogEvent.ingestionTime(), INGESTIONTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

