/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricFilterMatchRecord;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MetricFilterMatchRecordMarshaller {
    private static final MarshallingInfo<Long> EVENTNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventNumber").isBinary(false).build();
    private static final MarshallingInfo<String> EVENTMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventMessage").isBinary(false).build();
    private static final MarshallingInfo<Map> EXTRACTEDVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("extractedValues").isBinary(false).build();
    private static final MetricFilterMatchRecordMarshaller INSTANCE = new MetricFilterMatchRecordMarshaller();

    private MetricFilterMatchRecordMarshaller() {
    }

    public static MetricFilterMatchRecordMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MetricFilterMatchRecord metricFilterMatchRecord, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)metricFilterMatchRecord, (String)"metricFilterMatchRecord");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)metricFilterMatchRecord.eventNumber(), EVENTNUMBER_BINDING);
            protocolMarshaller.marshall((Object)metricFilterMatchRecord.eventMessage(), EVENTMESSAGE_BINDING);
            protocolMarshaller.marshall(metricFilterMatchRecord.extractedValues(), EXTRACTEDVALUES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

