/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilteredLogEvent;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FilteredLogEventMarshaller {
    private static final MarshallingInfo<String> LOGSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logStreamName").isBinary(false).build();
    private static final MarshallingInfo<Long> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").isBinary(false).build();
    private static final MarshallingInfo<Long> INGESTIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ingestionTime").isBinary(false).build();
    private static final MarshallingInfo<String> EVENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventId").isBinary(false).build();
    private static final FilteredLogEventMarshaller INSTANCE = new FilteredLogEventMarshaller();

    private FilteredLogEventMarshaller() {
    }

    public static FilteredLogEventMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FilteredLogEvent filteredLogEvent, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)filteredLogEvent, (String)"filteredLogEvent");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)filteredLogEvent.logStreamName(), LOGSTREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)filteredLogEvent.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)filteredLogEvent.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)filteredLogEvent.ingestionTime(), INGESTIONTIME_BINDING);
            protocolMarshaller.marshall((Object)filteredLogEvent.eventId(), EVENTID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

