/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeExportTasksRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeExportTasksRequestModelMarshaller {
    private static final MarshallingInfo<String> TASKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskId").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusCode").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("limit").isBinary(false).build();
    private static final DescribeExportTasksRequestModelMarshaller INSTANCE = new DescribeExportTasksRequestModelMarshaller();

    private DescribeExportTasksRequestModelMarshaller() {
    }

    public static DescribeExportTasksRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeExportTasksRequest describeExportTasksRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeExportTasksRequest), (String)"describeExportTasksRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeExportTasksRequest.taskId(), TASKID_BINDING);
            protocolMarshaller.marshall((Object)describeExportTasksRequest.statusCodeAsString(), STATUSCODE_BINDING);
            protocolMarshaller.marshall((Object)describeExportTasksRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)describeExportTasksRequest.limit(), LIMIT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

