/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateLogStreamRequestModelMarshaller {
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupName").isBinary(false).build();
    private static final MarshallingInfo<String> LOGSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logStreamName").isBinary(false).build();
    private static final CreateLogStreamRequestModelMarshaller INSTANCE = new CreateLogStreamRequestModelMarshaller();

    private CreateLogStreamRequestModelMarshaller() {
    }

    public static CreateLogStreamRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateLogStreamRequest createLogStreamRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createLogStreamRequest), (String)"createLogStreamRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createLogStreamRequest.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)createLogStreamRequest.logStreamName(), LOGSTREAMNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

