/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateLogGroupRequestModelMarshaller {
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupName").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsKeyId").isBinary(false).build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").isBinary(false).build();
    private static final CreateLogGroupRequestModelMarshaller INSTANCE = new CreateLogGroupRequestModelMarshaller();

    private CreateLogGroupRequestModelMarshaller() {
    }

    public static CreateLogGroupRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateLogGroupRequest createLogGroupRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createLogGroupRequest), (String)"createLogGroupRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createLogGroupRequest.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)createLogGroupRequest.kmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall(createLogGroupRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

