/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.AssociateKmsKeyRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AssociateKmsKeyRequestModelMarshaller {
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupName").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsKeyId").isBinary(false).build();
    private static final AssociateKmsKeyRequestModelMarshaller INSTANCE = new AssociateKmsKeyRequestModelMarshaller();

    private AssociateKmsKeyRequestModelMarshaller() {
    }

    public static AssociateKmsKeyRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AssociateKmsKeyRequest associateKmsKeyRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)associateKmsKeyRequest), (String)"associateKmsKeyRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)associateKmsKeyRequest.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)associateKmsKeyRequest.kmsKeyId(), KMSKEYID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

