/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.SearchedLogStreamMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchedLogStream
implements StructuredPojo,
ToCopyableBuilder<Builder, SearchedLogStream> {
    private final String logStreamName;
    private final Boolean searchedCompletely;

    private SearchedLogStream(BuilderImpl builder) {
        this.logStreamName = builder.logStreamName;
        this.searchedCompletely = builder.searchedCompletely;
    }

    public String logStreamName() {
        return this.logStreamName;
    }

    public Boolean searchedCompletely() {
        return this.searchedCompletely;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchedCompletely());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchedLogStream)) {
            return false;
        }
        SearchedLogStream other = (SearchedLogStream)obj;
        return Objects.equals(this.logStreamName(), other.logStreamName()) && Objects.equals(this.searchedCompletely(), other.searchedCompletely());
    }

    public String toString() {
        return ToString.builder((String)"SearchedLogStream").add("LogStreamName", (Object)this.logStreamName()).add("SearchedCompletely", (Object)this.searchedCompletely()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logStreamName": {
                return Optional.ofNullable(clazz.cast(this.logStreamName()));
            }
            case "searchedCompletely": {
                return Optional.ofNullable(clazz.cast(this.searchedCompletely()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SearchedLogStreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String logStreamName;
        private Boolean searchedCompletely;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchedLogStream model) {
            this.logStreamName(model.logStreamName);
            this.searchedCompletely(model.searchedCompletely);
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public final Boolean getSearchedCompletely() {
            return this.searchedCompletely;
        }

        @Override
        public final Builder searchedCompletely(Boolean searchedCompletely) {
            this.searchedCompletely = searchedCompletely;
            return this;
        }

        public final void setSearchedCompletely(Boolean searchedCompletely) {
            this.searchedCompletely = searchedCompletely;
        }

        public SearchedLogStream build() {
            return new SearchedLogStream(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SearchedLogStream> {
        public Builder logStreamName(String var1);

        public Builder searchedCompletely(Boolean var1);
    }
}

