/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDestinationPolicyRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, PutDestinationPolicyRequest> {
    private final String destinationName;
    private final String accessPolicy;

    private PutDestinationPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.destinationName = builder.destinationName;
        this.accessPolicy = builder.accessPolicy;
    }

    public String destinationName() {
        return this.destinationName;
    }

    public String accessPolicy() {
        return this.accessPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDestinationPolicyRequest)) {
            return false;
        }
        PutDestinationPolicyRequest other = (PutDestinationPolicyRequest)((Object)obj);
        return Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.accessPolicy(), other.accessPolicy());
    }

    public String toString() {
        return ToString.builder((String)"PutDestinationPolicyRequest").add("DestinationName", (Object)this.destinationName()).add("AccessPolicy", (Object)this.accessPolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "accessPolicy": {
                return Optional.ofNullable(clazz.cast(this.accessPolicy()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String destinationName;
        private String accessPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDestinationPolicyRequest model) {
            super(model);
            this.destinationName(model.destinationName);
            this.accessPolicy(model.accessPolicy);
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        public final String getAccessPolicy() {
            return this.accessPolicy;
        }

        @Override
        public final Builder accessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        public final void setAccessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDestinationPolicyRequest build() {
            return new PutDestinationPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    CopyableBuilder<Builder, PutDestinationPolicyRequest> {
        public Builder destinationName(String var1);

        public Builder accessPolicy(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

