/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.LogStreamMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogStream
implements StructuredPojo,
ToCopyableBuilder<Builder, LogStream> {
    private final String logStreamName;
    private final Long creationTime;
    private final Long firstEventTimestamp;
    private final Long lastEventTimestamp;
    private final Long lastIngestionTime;
    private final String uploadSequenceToken;
    private final String arn;
    private final Long storedBytes;

    private LogStream(BuilderImpl builder) {
        this.logStreamName = builder.logStreamName;
        this.creationTime = builder.creationTime;
        this.firstEventTimestamp = builder.firstEventTimestamp;
        this.lastEventTimestamp = builder.lastEventTimestamp;
        this.lastIngestionTime = builder.lastIngestionTime;
        this.uploadSequenceToken = builder.uploadSequenceToken;
        this.arn = builder.arn;
        this.storedBytes = builder.storedBytes;
    }

    public String logStreamName() {
        return this.logStreamName;
    }

    public Long creationTime() {
        return this.creationTime;
    }

    public Long firstEventTimestamp() {
        return this.firstEventTimestamp;
    }

    public Long lastEventTimestamp() {
        return this.lastEventTimestamp;
    }

    public Long lastIngestionTime() {
        return this.lastIngestionTime;
    }

    public String uploadSequenceToken() {
        return this.uploadSequenceToken;
    }

    public String arn() {
        return this.arn;
    }

    public Long storedBytes() {
        return this.storedBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstEventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastIngestionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadSequenceToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.storedBytes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogStream)) {
            return false;
        }
        LogStream other = (LogStream)obj;
        return Objects.equals(this.logStreamName(), other.logStreamName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.firstEventTimestamp(), other.firstEventTimestamp()) && Objects.equals(this.lastEventTimestamp(), other.lastEventTimestamp()) && Objects.equals(this.lastIngestionTime(), other.lastIngestionTime()) && Objects.equals(this.uploadSequenceToken(), other.uploadSequenceToken()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.storedBytes(), other.storedBytes());
    }

    public String toString() {
        return ToString.builder((String)"LogStream").add("LogStreamName", (Object)this.logStreamName()).add("CreationTime", (Object)this.creationTime()).add("FirstEventTimestamp", (Object)this.firstEventTimestamp()).add("LastEventTimestamp", (Object)this.lastEventTimestamp()).add("LastIngestionTime", (Object)this.lastIngestionTime()).add("UploadSequenceToken", (Object)this.uploadSequenceToken()).add("Arn", (Object)this.arn()).add("StoredBytes", (Object)this.storedBytes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logStreamName": {
                return Optional.ofNullable(clazz.cast(this.logStreamName()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "firstEventTimestamp": {
                return Optional.ofNullable(clazz.cast(this.firstEventTimestamp()));
            }
            case "lastEventTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastEventTimestamp()));
            }
            case "lastIngestionTime": {
                return Optional.ofNullable(clazz.cast(this.lastIngestionTime()));
            }
            case "uploadSequenceToken": {
                return Optional.ofNullable(clazz.cast(this.uploadSequenceToken()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "storedBytes": {
                return Optional.ofNullable(clazz.cast(this.storedBytes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogStreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String logStreamName;
        private Long creationTime;
        private Long firstEventTimestamp;
        private Long lastEventTimestamp;
        private Long lastIngestionTime;
        private String uploadSequenceToken;
        private String arn;
        private Long storedBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(LogStream model) {
            this.logStreamName(model.logStreamName);
            this.creationTime(model.creationTime);
            this.firstEventTimestamp(model.firstEventTimestamp);
            this.lastEventTimestamp(model.lastEventTimestamp);
            this.lastIngestionTime(model.lastIngestionTime);
            this.uploadSequenceToken(model.uploadSequenceToken);
            this.arn(model.arn);
            this.storedBytes(model.storedBytes);
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        public final Long getFirstEventTimestamp() {
            return this.firstEventTimestamp;
        }

        @Override
        public final Builder firstEventTimestamp(Long firstEventTimestamp) {
            this.firstEventTimestamp = firstEventTimestamp;
            return this;
        }

        public final void setFirstEventTimestamp(Long firstEventTimestamp) {
            this.firstEventTimestamp = firstEventTimestamp;
        }

        public final Long getLastEventTimestamp() {
            return this.lastEventTimestamp;
        }

        @Override
        public final Builder lastEventTimestamp(Long lastEventTimestamp) {
            this.lastEventTimestamp = lastEventTimestamp;
            return this;
        }

        public final void setLastEventTimestamp(Long lastEventTimestamp) {
            this.lastEventTimestamp = lastEventTimestamp;
        }

        public final Long getLastIngestionTime() {
            return this.lastIngestionTime;
        }

        @Override
        public final Builder lastIngestionTime(Long lastIngestionTime) {
            this.lastIngestionTime = lastIngestionTime;
            return this;
        }

        public final void setLastIngestionTime(Long lastIngestionTime) {
            this.lastIngestionTime = lastIngestionTime;
        }

        public final String getUploadSequenceToken() {
            return this.uploadSequenceToken;
        }

        @Override
        public final Builder uploadSequenceToken(String uploadSequenceToken) {
            this.uploadSequenceToken = uploadSequenceToken;
            return this;
        }

        public final void setUploadSequenceToken(String uploadSequenceToken) {
            this.uploadSequenceToken = uploadSequenceToken;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Long getStoredBytes() {
            return this.storedBytes;
        }

        @Override
        public final Builder storedBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
            return this;
        }

        public final void setStoredBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
        }

        public LogStream build() {
            return new LogStream(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LogStream> {
        public Builder logStreamName(String var1);

        public Builder creationTime(Long var1);

        public Builder firstEventTimestamp(Long var1);

        public Builder lastEventTimestamp(Long var1);

        public Builder lastIngestionTime(Long var1);

        public Builder uploadSequenceToken(String var1);

        public Builder arn(String var1);

        public Builder storedBytes(Long var1);
    }
}

