/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSubscriptionFiltersRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, DescribeSubscriptionFiltersRequest> {
    private final String logGroupName;
    private final String filterNamePrefix;
    private final String nextToken;
    private final Integer limit;

    private DescribeSubscriptionFiltersRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.filterNamePrefix = builder.filterNamePrefix;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String filterNamePrefix() {
        return this.filterNamePrefix;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubscriptionFiltersRequest)) {
            return false;
        }
        DescribeSubscriptionFiltersRequest other = (DescribeSubscriptionFiltersRequest)((Object)obj);
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.filterNamePrefix(), other.filterNamePrefix()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.limit(), other.limit());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSubscriptionFiltersRequest").add("LogGroupName", (Object)this.logGroupName()).add("FilterNamePrefix", (Object)this.filterNamePrefix()).add("NextToken", (Object)this.nextToken()).add("Limit", (Object)this.limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "filterNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.filterNamePrefix()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String logGroupName;
        private String filterNamePrefix;
        private String nextToken;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubscriptionFiltersRequest model) {
            super(model);
            this.logGroupName(model.logGroupName);
            this.filterNamePrefix(model.filterNamePrefix);
            this.nextToken(model.nextToken);
            this.limit(model.limit);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getFilterNamePrefix() {
            return this.filterNamePrefix;
        }

        @Override
        public final Builder filterNamePrefix(String filterNamePrefix) {
            this.filterNamePrefix = filterNamePrefix;
            return this;
        }

        public final void setFilterNamePrefix(String filterNamePrefix) {
            this.filterNamePrefix = filterNamePrefix;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSubscriptionFiltersRequest build() {
            return new DescribeSubscriptionFiltersRequest(this);
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    CopyableBuilder<Builder, DescribeSubscriptionFiltersRequest> {
        public Builder logGroupName(String var1);

        public Builder filterNamePrefix(String var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

