/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestEventPatternRequest
extends CloudWatchEventsRequest
implements ToCopyableBuilder<Builder, TestEventPatternRequest> {
    private static final SdkField<String> EVENT_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestEventPatternRequest.getter(TestEventPatternRequest::eventPattern)).setter(TestEventPatternRequest.setter(Builder::eventPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventPattern").build()}).build();
    private static final SdkField<String> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestEventPatternRequest.getter(TestEventPatternRequest::event)).setter(TestEventPatternRequest.setter(Builder::event)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_PATTERN_FIELD, EVENT_FIELD));
    private final String eventPattern;
    private final String event;

    private TestEventPatternRequest(BuilderImpl builder) {
        super(builder);
        this.eventPattern = builder.eventPattern;
        this.event = builder.event;
    }

    public String eventPattern() {
        return this.eventPattern;
    }

    public String event() {
        return this.event;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.event());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestEventPatternRequest)) {
            return false;
        }
        TestEventPatternRequest other = (TestEventPatternRequest)((Object)obj);
        return Objects.equals(this.eventPattern(), other.eventPattern()) && Objects.equals(this.event(), other.event());
    }

    public String toString() {
        return ToString.builder((String)"TestEventPatternRequest").add("EventPattern", (Object)this.eventPattern()).add("Event", (Object)this.event()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventPattern": {
                return Optional.ofNullable(clazz.cast(this.eventPattern()));
            }
            case "Event": {
                return Optional.ofNullable(clazz.cast(this.event()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestEventPatternRequest, T> g) {
        return obj -> g.apply((TestEventPatternRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchEventsRequest.BuilderImpl
    implements Builder {
        private String eventPattern;
        private String event;

        private BuilderImpl() {
        }

        private BuilderImpl(TestEventPatternRequest model) {
            super(model);
            this.eventPattern(model.eventPattern);
            this.event(model.event);
        }

        public final String getEventPattern() {
            return this.eventPattern;
        }

        @Override
        public final Builder eventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        public final void setEventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
        }

        public final String getEvent() {
            return this.event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestEventPatternRequest build() {
            return new TestEventPatternRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchEventsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestEventPatternRequest> {
        public Builder eventPattern(String var1);

        public Builder event(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

