/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.Replay;
import software.amazon.awssdk.services.cloudwatchevents.model.ReplayListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReplaysResponse
extends CloudWatchEventsResponse
implements ToCopyableBuilder<Builder, ListReplaysResponse> {
    private static final SdkField<List<Replay>> REPLAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Replays").getter(ListReplaysResponse.getter(ListReplaysResponse::replays)).setter(ListReplaysResponse.setter(Builder::replays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replays").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Replay::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListReplaysResponse.getter(ListReplaysResponse::nextToken)).setter(ListReplaysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLAYS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListReplaysResponse.memberNameToFieldInitializer();
    private final List<Replay> replays;
    private final String nextToken;

    private ListReplaysResponse(BuilderImpl builder) {
        super(builder);
        this.replays = builder.replays;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasReplays() {
        return this.replays != null && !(this.replays instanceof SdkAutoConstructList);
    }

    public final List<Replay> replays() {
        return this.replays;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplays() ? this.replays() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReplaysResponse)) {
            return false;
        }
        ListReplaysResponse other = (ListReplaysResponse)((Object)obj);
        return this.hasReplays() == other.hasReplays() && Objects.equals(this.replays(), other.replays()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListReplaysResponse").add("Replays", this.hasReplays() ? this.replays() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Replays": {
                return Optional.ofNullable(clazz.cast(this.replays()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Replays", REPLAYS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReplaysResponse, T> g) {
        return obj -> g.apply((ListReplaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchEventsResponse.BuilderImpl
    implements Builder {
        private List<Replay> replays = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReplaysResponse model) {
            super(model);
            this.replays(model.replays);
            this.nextToken(model.nextToken);
        }

        public final List<Replay.Builder> getReplays() {
            List<Replay.Builder> result = ReplayListCopier.copyToBuilder(this.replays);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplays(Collection<Replay.BuilderImpl> replays) {
            this.replays = ReplayListCopier.copyFromBuilder(replays);
        }

        @Override
        public final Builder replays(Collection<Replay> replays) {
            this.replays = ReplayListCopier.copy(replays);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replays(Replay ... replays) {
            this.replays(Arrays.asList(replays));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replays(Consumer<Replay.Builder> ... replays) {
            this.replays(Stream.of(replays).map(c -> (Replay)((Replay.Builder)Replay.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReplaysResponse build() {
            return new ListReplaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchEventsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReplaysResponse> {
        public Builder replays(Collection<Replay> var1);

        public Builder replays(Replay ... var1);

        public Builder replays(Consumer<Replay.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

