/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatchevents.CloudWatchEventsClient;
import software.amazon.awssdk.services.cloudwatchevents.CloudWatchEventsClientBuilder;
import software.amazon.awssdk.services.cloudwatchevents.CloudWatchEventsServiceClientConfiguration;
import software.amazon.awssdk.services.cloudwatchevents.DefaultCloudWatchEventsBaseClientBuilder;
import software.amazon.awssdk.services.cloudwatchevents.DefaultCloudWatchEventsClient;
import software.amazon.awssdk.services.cloudwatchevents.endpoints.CloudWatchEventsEndpointProvider;

@SdkInternalApi
final class DefaultCloudWatchEventsClientBuilder
extends DefaultCloudWatchEventsBaseClientBuilder<CloudWatchEventsClientBuilder, CloudWatchEventsClient>
implements CloudWatchEventsClientBuilder {
    DefaultCloudWatchEventsClientBuilder() {
    }

    @Override
    public DefaultCloudWatchEventsClientBuilder endpointProvider(CloudWatchEventsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudWatchEventsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCloudWatchEventsClientBuilder.validateClientOptions(clientConfiguration);
        CloudWatchEventsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCloudWatchEventsClient client = new DefaultCloudWatchEventsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CloudWatchEventsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CloudWatchEventsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

