/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchevents.model.ConnectionHttpParameters;
import software.amazon.awssdk.services.cloudwatchevents.model.ConnectionOAuthHttpMethod;
import software.amazon.awssdk.services.cloudwatchevents.model.UpdateConnectionOAuthClientRequestParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConnectionOAuthRequestParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateConnectionOAuthRequestParameters> {
    private static final SdkField<UpdateConnectionOAuthClientRequestParameters> CLIENT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientParameters").getter(UpdateConnectionOAuthRequestParameters.getter(UpdateConnectionOAuthRequestParameters::clientParameters)).setter(UpdateConnectionOAuthRequestParameters.setter(Builder::clientParameters)).constructor(UpdateConnectionOAuthClientRequestParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientParameters").build()}).build();
    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorizationEndpoint").getter(UpdateConnectionOAuthRequestParameters.getter(UpdateConnectionOAuthRequestParameters::authorizationEndpoint)).setter(UpdateConnectionOAuthRequestParameters.setter(Builder::authorizationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationEndpoint").build()}).build();
    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpMethod").getter(UpdateConnectionOAuthRequestParameters.getter(UpdateConnectionOAuthRequestParameters::httpMethodAsString)).setter(UpdateConnectionOAuthRequestParameters.setter(Builder::httpMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpMethod").build()}).build();
    private static final SdkField<ConnectionHttpParameters> O_AUTH_HTTP_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OAuthHttpParameters").getter(UpdateConnectionOAuthRequestParameters.getter(UpdateConnectionOAuthRequestParameters::oAuthHttpParameters)).setter(UpdateConnectionOAuthRequestParameters.setter(Builder::oAuthHttpParameters)).constructor(ConnectionHttpParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthHttpParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_PARAMETERS_FIELD, AUTHORIZATION_ENDPOINT_FIELD, HTTP_METHOD_FIELD, O_AUTH_HTTP_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final UpdateConnectionOAuthClientRequestParameters clientParameters;
    private final String authorizationEndpoint;
    private final String httpMethod;
    private final ConnectionHttpParameters oAuthHttpParameters;

    private UpdateConnectionOAuthRequestParameters(BuilderImpl builder) {
        this.clientParameters = builder.clientParameters;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.httpMethod = builder.httpMethod;
        this.oAuthHttpParameters = builder.oAuthHttpParameters;
    }

    public final UpdateConnectionOAuthClientRequestParameters clientParameters() {
        return this.clientParameters;
    }

    public final String authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public final ConnectionOAuthHttpMethod httpMethod() {
        return ConnectionOAuthHttpMethod.fromValue(this.httpMethod);
    }

    public final String httpMethodAsString() {
        return this.httpMethod;
    }

    public final ConnectionHttpParameters oAuthHttpParameters() {
        return this.oAuthHttpParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuthHttpParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionOAuthRequestParameters)) {
            return false;
        }
        UpdateConnectionOAuthRequestParameters other = (UpdateConnectionOAuthRequestParameters)obj;
        return Objects.equals(this.clientParameters(), other.clientParameters()) && Objects.equals(this.authorizationEndpoint(), other.authorizationEndpoint()) && Objects.equals(this.httpMethodAsString(), other.httpMethodAsString()) && Objects.equals(this.oAuthHttpParameters(), other.oAuthHttpParameters());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConnectionOAuthRequestParameters").add("ClientParameters", (Object)this.clientParameters()).add("AuthorizationEndpoint", (Object)this.authorizationEndpoint()).add("HttpMethod", (Object)this.httpMethodAsString()).add("OAuthHttpParameters", (Object)this.oAuthHttpParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientParameters": {
                return Optional.ofNullable(clazz.cast(this.clientParameters()));
            }
            case "AuthorizationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.authorizationEndpoint()));
            }
            case "HttpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethodAsString()));
            }
            case "OAuthHttpParameters": {
                return Optional.ofNullable(clazz.cast(this.oAuthHttpParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionOAuthRequestParameters, T> g) {
        return obj -> g.apply((UpdateConnectionOAuthRequestParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private UpdateConnectionOAuthClientRequestParameters clientParameters;
        private String authorizationEndpoint;
        private String httpMethod;
        private ConnectionHttpParameters oAuthHttpParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionOAuthRequestParameters model) {
            this.clientParameters(model.clientParameters);
            this.authorizationEndpoint(model.authorizationEndpoint);
            this.httpMethod(model.httpMethod);
            this.oAuthHttpParameters(model.oAuthHttpParameters);
        }

        public final UpdateConnectionOAuthClientRequestParameters.Builder getClientParameters() {
            return this.clientParameters != null ? this.clientParameters.toBuilder() : null;
        }

        public final void setClientParameters(UpdateConnectionOAuthClientRequestParameters.BuilderImpl clientParameters) {
            this.clientParameters = clientParameters != null ? clientParameters.build() : null;
        }

        @Override
        public final Builder clientParameters(UpdateConnectionOAuthClientRequestParameters clientParameters) {
            this.clientParameters = clientParameters;
            return this;
        }

        public final String getAuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Override
        public final Builder httpMethod(ConnectionOAuthHttpMethod httpMethod) {
            this.httpMethod(httpMethod == null ? null : httpMethod.toString());
            return this;
        }

        public final ConnectionHttpParameters.Builder getOAuthHttpParameters() {
            return this.oAuthHttpParameters != null ? this.oAuthHttpParameters.toBuilder() : null;
        }

        public final void setOAuthHttpParameters(ConnectionHttpParameters.BuilderImpl oAuthHttpParameters) {
            this.oAuthHttpParameters = oAuthHttpParameters != null ? oAuthHttpParameters.build() : null;
        }

        @Override
        public final Builder oAuthHttpParameters(ConnectionHttpParameters oAuthHttpParameters) {
            this.oAuthHttpParameters = oAuthHttpParameters;
            return this;
        }

        public UpdateConnectionOAuthRequestParameters build() {
            return new UpdateConnectionOAuthRequestParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateConnectionOAuthRequestParameters> {
        public Builder clientParameters(UpdateConnectionOAuthClientRequestParameters var1);

        default public Builder clientParameters(Consumer<UpdateConnectionOAuthClientRequestParameters.Builder> clientParameters) {
            return this.clientParameters((UpdateConnectionOAuthClientRequestParameters)((UpdateConnectionOAuthClientRequestParameters.Builder)UpdateConnectionOAuthClientRequestParameters.builder().applyMutation(clientParameters)).build());
        }

        public Builder authorizationEndpoint(String var1);

        public Builder httpMethod(String var1);

        public Builder httpMethod(ConnectionOAuthHttpMethod var1);

        public Builder oAuthHttpParameters(ConnectionHttpParameters var1);

        default public Builder oAuthHttpParameters(Consumer<ConnectionHttpParameters.Builder> oAuthHttpParameters) {
            return this.oAuthHttpParameters((ConnectionHttpParameters)((ConnectionHttpParameters.Builder)ConnectionHttpParameters.builder().applyMutation(oAuthHttpParameters)).build());
        }
    }
}

