/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutEventsResultEntry;
import software.amazon.awssdk.services.cloudwatchevents.model.PutEventsResultEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEventsResponse
extends CloudWatchEventsResponse
implements ToCopyableBuilder<Builder, PutEventsResponse> {
    private static final SdkField<Integer> FAILED_ENTRY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailedEntryCount").getter(PutEventsResponse.getter(PutEventsResponse::failedEntryCount)).setter(PutEventsResponse.setter(Builder::failedEntryCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedEntryCount").build()}).build();
    private static final SdkField<List<PutEventsResultEntry>> ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entries").getter(PutEventsResponse.getter(PutEventsResponse::entries)).setter(PutEventsResponse.setter(Builder::entries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PutEventsResultEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_ENTRY_COUNT_FIELD, ENTRIES_FIELD));
    private final Integer failedEntryCount;
    private final List<PutEventsResultEntry> entries;

    private PutEventsResponse(BuilderImpl builder) {
        super(builder);
        this.failedEntryCount = builder.failedEntryCount;
        this.entries = builder.entries;
    }

    public final Integer failedEntryCount() {
        return this.failedEntryCount;
    }

    public final boolean hasEntries() {
        return this.entries != null && !(this.entries instanceof SdkAutoConstructList);
    }

    public final List<PutEventsResultEntry> entries() {
        return this.entries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.failedEntryCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntries() ? this.entries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventsResponse)) {
            return false;
        }
        PutEventsResponse other = (PutEventsResponse)((Object)obj);
        return Objects.equals(this.failedEntryCount(), other.failedEntryCount()) && this.hasEntries() == other.hasEntries() && Objects.equals(this.entries(), other.entries());
    }

    public final String toString() {
        return ToString.builder((String)"PutEventsResponse").add("FailedEntryCount", (Object)this.failedEntryCount()).add("Entries", this.hasEntries() ? this.entries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedEntryCount": {
                return Optional.ofNullable(clazz.cast(this.failedEntryCount()));
            }
            case "Entries": {
                return Optional.ofNullable(clazz.cast(this.entries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEventsResponse, T> g) {
        return obj -> g.apply((PutEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchEventsResponse.BuilderImpl
    implements Builder {
        private Integer failedEntryCount;
        private List<PutEventsResultEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventsResponse model) {
            super(model);
            this.failedEntryCount(model.failedEntryCount);
            this.entries(model.entries);
        }

        public final Integer getFailedEntryCount() {
            return this.failedEntryCount;
        }

        public final void setFailedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
        }

        @Override
        @Transient
        public final Builder failedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
            return this;
        }

        public final List<PutEventsResultEntry.Builder> getEntries() {
            List<PutEventsResultEntry.Builder> result = PutEventsResultEntryListCopier.copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<PutEventsResultEntry.BuilderImpl> entries) {
            this.entries = PutEventsResultEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        @Transient
        public final Builder entries(Collection<PutEventsResultEntry> entries) {
            this.entries = PutEventsResultEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entries(PutEventsResultEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entries(Consumer<PutEventsResultEntry.Builder> ... entries) {
            this.entries(Stream.of(entries).map(c -> (PutEventsResultEntry)((PutEventsResultEntry.Builder)PutEventsResultEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutEventsResponse build() {
            return new PutEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchEventsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutEventsResponse> {
        public Builder failedEntryCount(Integer var1);

        public Builder entries(Collection<PutEventsResultEntry> var1);

        public Builder entries(PutEventsResultEntry ... var1);

        public Builder entries(Consumer<PutEventsResultEntry.Builder> ... var1);
    }
}

