/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchevents.model.CapacityProviderStrategyCopier;
import software.amazon.awssdk.services.cloudwatchevents.model.CapacityProviderStrategyItem;
import software.amazon.awssdk.services.cloudwatchevents.model.LaunchType;
import software.amazon.awssdk.services.cloudwatchevents.model.NetworkConfiguration;
import software.amazon.awssdk.services.cloudwatchevents.model.PlacementConstraint;
import software.amazon.awssdk.services.cloudwatchevents.model.PlacementConstraintsCopier;
import software.amazon.awssdk.services.cloudwatchevents.model.PlacementStrategiesCopier;
import software.amazon.awssdk.services.cloudwatchevents.model.PlacementStrategy;
import software.amazon.awssdk.services.cloudwatchevents.model.PropagateTags;
import software.amazon.awssdk.services.cloudwatchevents.model.Tag;
import software.amazon.awssdk.services.cloudwatchevents.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcsParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EcsParameters> {
    private static final SdkField<String> TASK_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskDefinitionArn").getter(EcsParameters.getter(EcsParameters::taskDefinitionArn)).setter(EcsParameters.setter(Builder::taskDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskDefinitionArn").build()}).build();
    private static final SdkField<Integer> TASK_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TaskCount").getter(EcsParameters.getter(EcsParameters::taskCount)).setter(EcsParameters.setter(Builder::taskCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskCount").build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchType").getter(EcsParameters.getter(EcsParameters::launchTypeAsString)).setter(EcsParameters.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchType").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfiguration").getter(EcsParameters.getter(EcsParameters::networkConfiguration)).setter(EcsParameters.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformVersion").getter(EcsParameters.getter(EcsParameters::platformVersion)).setter(EcsParameters.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Group").getter(EcsParameters.getter(EcsParameters::group)).setter(EcsParameters.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()}).build();
    private static final SdkField<List<CapacityProviderStrategyItem>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityProviderStrategy").getter(EcsParameters.getter(EcsParameters::capacityProviderStrategy)).setter(EcsParameters.setter(Builder::capacityProviderStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityProviderStrategyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_ECS_MANAGED_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableECSManagedTags").getter(EcsParameters.getter(EcsParameters::enableECSManagedTags)).setter(EcsParameters.setter(Builder::enableECSManagedTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableECSManagedTags").build()}).build();
    private static final SdkField<Boolean> ENABLE_EXECUTE_COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableExecuteCommand").getter(EcsParameters.getter(EcsParameters::enableExecuteCommand)).setter(EcsParameters.setter(Builder::enableExecuteCommand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableExecuteCommand").build()}).build();
    private static final SdkField<List<PlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PlacementConstraints").getter(EcsParameters.getter(EcsParameters::placementConstraints)).setter(EcsParameters.setter(Builder::placementConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PlacementStrategy>> PLACEMENT_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PlacementStrategy").getter(EcsParameters.getter(EcsParameters::placementStrategy)).setter(EcsParameters.setter(Builder::placementStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PropagateTags").getter(EcsParameters.getter(EcsParameters::propagateTagsAsString)).setter(EcsParameters.setter(Builder::propagateTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropagateTags").build()}).build();
    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReferenceId").getter(EcsParameters.getter(EcsParameters::referenceId)).setter(EcsParameters.setter(Builder::referenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(EcsParameters.getter(EcsParameters::tags)).setter(EcsParameters.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_DEFINITION_ARN_FIELD, TASK_COUNT_FIELD, LAUNCH_TYPE_FIELD, NETWORK_CONFIGURATION_FIELD, PLATFORM_VERSION_FIELD, GROUP_FIELD, CAPACITY_PROVIDER_STRATEGY_FIELD, ENABLE_ECS_MANAGED_TAGS_FIELD, ENABLE_EXECUTE_COMMAND_FIELD, PLACEMENT_CONSTRAINTS_FIELD, PLACEMENT_STRATEGY_FIELD, PROPAGATE_TAGS_FIELD, REFERENCE_ID_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String taskDefinitionArn;
    private final Integer taskCount;
    private final String launchType;
    private final NetworkConfiguration networkConfiguration;
    private final String platformVersion;
    private final String group;
    private final List<CapacityProviderStrategyItem> capacityProviderStrategy;
    private final Boolean enableECSManagedTags;
    private final Boolean enableExecuteCommand;
    private final List<PlacementConstraint> placementConstraints;
    private final List<PlacementStrategy> placementStrategy;
    private final String propagateTags;
    private final String referenceId;
    private final List<Tag> tags;

    private EcsParameters(BuilderImpl builder) {
        this.taskDefinitionArn = builder.taskDefinitionArn;
        this.taskCount = builder.taskCount;
        this.launchType = builder.launchType;
        this.networkConfiguration = builder.networkConfiguration;
        this.platformVersion = builder.platformVersion;
        this.group = builder.group;
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.enableECSManagedTags = builder.enableECSManagedTags;
        this.enableExecuteCommand = builder.enableExecuteCommand;
        this.placementConstraints = builder.placementConstraints;
        this.placementStrategy = builder.placementStrategy;
        this.propagateTags = builder.propagateTags;
        this.referenceId = builder.referenceId;
        this.tags = builder.tags;
    }

    public final String taskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public final Integer taskCount() {
        return this.taskCount;
    }

    public final LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public final String launchTypeAsString() {
        return this.launchType;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final String group() {
        return this.group;
    }

    public final boolean hasCapacityProviderStrategy() {
        return this.capacityProviderStrategy != null && !(this.capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    public final List<CapacityProviderStrategyItem> capacityProviderStrategy() {
        return this.capacityProviderStrategy;
    }

    public final Boolean enableECSManagedTags() {
        return this.enableECSManagedTags;
    }

    public final Boolean enableExecuteCommand() {
        return this.enableExecuteCommand;
    }

    public final boolean hasPlacementConstraints() {
        return this.placementConstraints != null && !(this.placementConstraints instanceof SdkAutoConstructList);
    }

    public final List<PlacementConstraint> placementConstraints() {
        return this.placementConstraints;
    }

    public final boolean hasPlacementStrategy() {
        return this.placementStrategy != null && !(this.placementStrategy instanceof SdkAutoConstructList);
    }

    public final List<PlacementStrategy> placementStrategy() {
        return this.placementStrategy;
    }

    public final PropagateTags propagateTags() {
        return PropagateTags.fromValue(this.propagateTags);
    }

    public final String propagateTagsAsString() {
        return this.propagateTags;
    }

    public final String referenceId() {
        return this.referenceId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityProviderStrategy() ? this.capacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableECSManagedTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableExecuteCommand());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlacementConstraints() ? this.placementConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlacementStrategy() ? this.placementStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.propagateTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsParameters)) {
            return false;
        }
        EcsParameters other = (EcsParameters)obj;
        return Objects.equals(this.taskDefinitionArn(), other.taskDefinitionArn()) && Objects.equals(this.taskCount(), other.taskCount()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.group(), other.group()) && this.hasCapacityProviderStrategy() == other.hasCapacityProviderStrategy() && Objects.equals(this.capacityProviderStrategy(), other.capacityProviderStrategy()) && Objects.equals(this.enableECSManagedTags(), other.enableECSManagedTags()) && Objects.equals(this.enableExecuteCommand(), other.enableExecuteCommand()) && this.hasPlacementConstraints() == other.hasPlacementConstraints() && Objects.equals(this.placementConstraints(), other.placementConstraints()) && this.hasPlacementStrategy() == other.hasPlacementStrategy() && Objects.equals(this.placementStrategy(), other.placementStrategy()) && Objects.equals(this.propagateTagsAsString(), other.propagateTagsAsString()) && Objects.equals(this.referenceId(), other.referenceId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"EcsParameters").add("TaskDefinitionArn", (Object)this.taskDefinitionArn()).add("TaskCount", (Object)this.taskCount()).add("LaunchType", (Object)this.launchTypeAsString()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("PlatformVersion", (Object)this.platformVersion()).add("Group", (Object)this.group()).add("CapacityProviderStrategy", this.hasCapacityProviderStrategy() ? this.capacityProviderStrategy() : null).add("EnableECSManagedTags", (Object)this.enableECSManagedTags()).add("EnableExecuteCommand", (Object)this.enableExecuteCommand()).add("PlacementConstraints", this.hasPlacementConstraints() ? this.placementConstraints() : null).add("PlacementStrategy", this.hasPlacementStrategy() ? this.placementStrategy() : null).add("PropagateTags", (Object)this.propagateTagsAsString()).add("ReferenceId", (Object)this.referenceId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.taskDefinitionArn()));
            }
            case "TaskCount": {
                return Optional.ofNullable(clazz.cast(this.taskCount()));
            }
            case "LaunchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "NetworkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "PlatformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "CapacityProviderStrategy": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderStrategy()));
            }
            case "EnableECSManagedTags": {
                return Optional.ofNullable(clazz.cast(this.enableECSManagedTags()));
            }
            case "EnableExecuteCommand": {
                return Optional.ofNullable(clazz.cast(this.enableExecuteCommand()));
            }
            case "PlacementConstraints": {
                return Optional.ofNullable(clazz.cast(this.placementConstraints()));
            }
            case "PlacementStrategy": {
                return Optional.ofNullable(clazz.cast(this.placementStrategy()));
            }
            case "PropagateTags": {
                return Optional.ofNullable(clazz.cast(this.propagateTagsAsString()));
            }
            case "ReferenceId": {
                return Optional.ofNullable(clazz.cast(this.referenceId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EcsParameters, T> g) {
        return obj -> g.apply((EcsParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskDefinitionArn;
        private Integer taskCount;
        private String launchType;
        private NetworkConfiguration networkConfiguration;
        private String platformVersion;
        private String group;
        private List<CapacityProviderStrategyItem> capacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableECSManagedTags;
        private Boolean enableExecuteCommand;
        private List<PlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();
        private List<PlacementStrategy> placementStrategy = DefaultSdkAutoConstructList.getInstance();
        private String propagateTags;
        private String referenceId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EcsParameters model) {
            this.taskDefinitionArn(model.taskDefinitionArn);
            this.taskCount(model.taskCount);
            this.launchType(model.launchType);
            this.networkConfiguration(model.networkConfiguration);
            this.platformVersion(model.platformVersion);
            this.group(model.group);
            this.capacityProviderStrategy(model.capacityProviderStrategy);
            this.enableECSManagedTags(model.enableECSManagedTags);
            this.enableExecuteCommand(model.enableExecuteCommand);
            this.placementConstraints(model.placementConstraints);
            this.placementStrategy(model.placementStrategy);
            this.propagateTags(model.propagateTags);
            this.referenceId(model.referenceId);
            this.tags(model.tags);
        }

        public final String getTaskDefinitionArn() {
            return this.taskDefinitionArn;
        }

        @Override
        public final Builder taskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
            return this;
        }

        public final void setTaskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
        }

        public final Integer getTaskCount() {
            return this.taskCount;
        }

        @Override
        public final Builder taskCount(Integer taskCount) {
            this.taskCount = taskCount;
            return this;
        }

        public final void setTaskCount(Integer taskCount) {
            this.taskCount = taskCount;
        }

        public final String getLaunchType() {
            return this.launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final List<CapacityProviderStrategyItem.Builder> getCapacityProviderStrategy() {
            List<CapacityProviderStrategyItem.Builder> result = CapacityProviderStrategyCopier.copyToBuilder(this.capacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(CapacityProviderStrategyItem ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Stream.of(capacityProviderStrategy).map(c -> (CapacityProviderStrategyItem)((CapacityProviderStrategyItem.Builder)CapacityProviderStrategyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCapacityProviderStrategy(Collection<CapacityProviderStrategyItem.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(capacityProviderStrategy);
        }

        public final Boolean getEnableECSManagedTags() {
            return this.enableECSManagedTags;
        }

        @Override
        public final Builder enableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
            return this;
        }

        public final void setEnableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
        }

        public final Boolean getEnableExecuteCommand() {
            return this.enableExecuteCommand;
        }

        @Override
        public final Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        public final void setEnableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
        }

        public final List<PlacementConstraint.Builder> getPlacementConstraints() {
            List<PlacementConstraint.Builder> result = PlacementConstraintsCopier.copyToBuilder(this.placementConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder placementConstraints(Collection<PlacementConstraint> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(PlacementConstraint ... placementConstraints) {
            this.placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<PlacementConstraint.Builder> ... placementConstraints) {
            this.placementConstraints(Stream.of(placementConstraints).map(c -> (PlacementConstraint)((PlacementConstraint.Builder)PlacementConstraint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementConstraints(Collection<PlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        public final List<PlacementStrategy.Builder> getPlacementStrategy() {
            List<PlacementStrategy.Builder> result = PlacementStrategiesCopier.copyToBuilder(this.placementStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder placementStrategy(Collection<PlacementStrategy> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copy(placementStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(PlacementStrategy ... placementStrategy) {
            this.placementStrategy(Arrays.asList(placementStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(Consumer<PlacementStrategy.Builder> ... placementStrategy) {
            this.placementStrategy(Stream.of(placementStrategy).map(c -> (PlacementStrategy)((PlacementStrategy.Builder)PlacementStrategy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementStrategy(Collection<PlacementStrategy.BuilderImpl> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copyFromBuilder(placementStrategy);
        }

        public final String getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(PropagateTags propagateTags) {
            this.propagateTags(propagateTags == null ? null : propagateTags.toString());
            return this;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        public final String getReferenceId() {
            return this.referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public EcsParameters build() {
            return new EcsParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EcsParameters> {
        public Builder taskDefinitionArn(String var1);

        public Builder taskCount(Integer var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder platformVersion(String var1);

        public Builder group(String var1);

        public Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> var1);

        public Builder capacityProviderStrategy(CapacityProviderStrategyItem ... var1);

        public Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... var1);

        public Builder enableECSManagedTags(Boolean var1);

        public Builder enableExecuteCommand(Boolean var1);

        public Builder placementConstraints(Collection<PlacementConstraint> var1);

        public Builder placementConstraints(PlacementConstraint ... var1);

        public Builder placementConstraints(Consumer<PlacementConstraint.Builder> ... var1);

        public Builder placementStrategy(Collection<PlacementStrategy> var1);

        public Builder placementStrategy(PlacementStrategy ... var1);

        public Builder placementStrategy(Consumer<PlacementStrategy.Builder> ... var1);

        public Builder propagateTags(String var1);

        public Builder propagateTags(PropagateTags var1);

        public Builder referenceId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

