/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatchevents.model.HeaderParametersMapCopier;
import software.amazon.awssdk.services.cloudwatchevents.model.PathParameterListCopier;
import software.amazon.awssdk.services.cloudwatchevents.model.QueryStringParametersMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpParameters> {
    private static final SdkField<List<String>> PATH_PARAMETER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PathParameterValues").getter(HttpParameters.getter(HttpParameters::pathParameterValues)).setter(HttpParameters.setter(Builder::pathParameterValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathParameterValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> HEADER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("HeaderParameters").getter(HttpParameters.getter(HttpParameters::headerParameters)).setter(HttpParameters.setter(Builder::headerParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> QUERY_STRING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("QueryStringParameters").getter(HttpParameters.getter(HttpParameters::queryStringParameters)).setter(HttpParameters.setter(Builder::queryStringParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStringParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_PARAMETER_VALUES_FIELD, HEADER_PARAMETERS_FIELD, QUERY_STRING_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> pathParameterValues;
    private final Map<String, String> headerParameters;
    private final Map<String, String> queryStringParameters;

    private HttpParameters(BuilderImpl builder) {
        this.pathParameterValues = builder.pathParameterValues;
        this.headerParameters = builder.headerParameters;
        this.queryStringParameters = builder.queryStringParameters;
    }

    public boolean hasPathParameterValues() {
        return this.pathParameterValues != null && !(this.pathParameterValues instanceof SdkAutoConstructList);
    }

    public List<String> pathParameterValues() {
        return this.pathParameterValues;
    }

    public boolean hasHeaderParameters() {
        return this.headerParameters != null && !(this.headerParameters instanceof SdkAutoConstructMap);
    }

    public Map<String, String> headerParameters() {
        return this.headerParameters;
    }

    public boolean hasQueryStringParameters() {
        return this.queryStringParameters != null && !(this.queryStringParameters instanceof SdkAutoConstructMap);
    }

    public Map<String, String> queryStringParameters() {
        return this.queryStringParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pathParameterValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.headerParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStringParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpParameters)) {
            return false;
        }
        HttpParameters other = (HttpParameters)obj;
        return Objects.equals(this.pathParameterValues(), other.pathParameterValues()) && Objects.equals(this.headerParameters(), other.headerParameters()) && Objects.equals(this.queryStringParameters(), other.queryStringParameters());
    }

    public String toString() {
        return ToString.builder((String)"HttpParameters").add("PathParameterValues", this.pathParameterValues()).add("HeaderParameters", this.headerParameters()).add("QueryStringParameters", this.queryStringParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PathParameterValues": {
                return Optional.ofNullable(clazz.cast(this.pathParameterValues()));
            }
            case "HeaderParameters": {
                return Optional.ofNullable(clazz.cast(this.headerParameters()));
            }
            case "QueryStringParameters": {
                return Optional.ofNullable(clazz.cast(this.queryStringParameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpParameters, T> g) {
        return obj -> g.apply((HttpParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> pathParameterValues = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> headerParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> queryStringParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HttpParameters model) {
            this.pathParameterValues(model.pathParameterValues);
            this.headerParameters(model.headerParameters);
            this.queryStringParameters(model.queryStringParameters);
        }

        public final Collection<String> getPathParameterValues() {
            return this.pathParameterValues;
        }

        @Override
        public final Builder pathParameterValues(Collection<String> pathParameterValues) {
            this.pathParameterValues = PathParameterListCopier.copy(pathParameterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathParameterValues(String ... pathParameterValues) {
            this.pathParameterValues(Arrays.asList(pathParameterValues));
            return this;
        }

        public final void setPathParameterValues(Collection<String> pathParameterValues) {
            this.pathParameterValues = PathParameterListCopier.copy(pathParameterValues);
        }

        public final Map<String, String> getHeaderParameters() {
            return this.headerParameters;
        }

        @Override
        public final Builder headerParameters(Map<String, String> headerParameters) {
            this.headerParameters = HeaderParametersMapCopier.copy(headerParameters);
            return this;
        }

        public final void setHeaderParameters(Map<String, String> headerParameters) {
            this.headerParameters = HeaderParametersMapCopier.copy(headerParameters);
        }

        public final Map<String, String> getQueryStringParameters() {
            return this.queryStringParameters;
        }

        @Override
        public final Builder queryStringParameters(Map<String, String> queryStringParameters) {
            this.queryStringParameters = QueryStringParametersMapCopier.copy(queryStringParameters);
            return this;
        }

        public final void setQueryStringParameters(Map<String, String> queryStringParameters) {
            this.queryStringParameters = QueryStringParametersMapCopier.copy(queryStringParameters);
        }

        public HttpParameters build() {
            return new HttpParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpParameters> {
        public Builder pathParameterValues(Collection<String> var1);

        public Builder pathParameterValues(String ... var1);

        public Builder headerParameters(Map<String, String> var1);

        public Builder queryStringParameters(Map<String, String> var1);
    }
}

