/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEventBusResponse extends CloudWatchEventsResponse implements
        ToCopyableBuilder<CreateEventBusResponse.Builder, CreateEventBusResponse> {
    private static final SdkField<String> EVENT_BUS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEventBusResponse::eventBusArn)).setter(setter(Builder::eventBusArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBusArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_BUS_ARN_FIELD));

    private final String eventBusArn;

    private CreateEventBusResponse(BuilderImpl builder) {
        super(builder);
        this.eventBusArn = builder.eventBusArn;
    }

    /**
     * <p>
     * The ARN of the new event bus.
     * </p>
     * 
     * @return The ARN of the new event bus.
     */
    public String eventBusArn() {
        return eventBusArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventBusArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventBusResponse)) {
            return false;
        }
        CreateEventBusResponse other = (CreateEventBusResponse) obj;
        return Objects.equals(eventBusArn(), other.eventBusArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateEventBusResponse").add("EventBusArn", eventBusArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventBusArn":
            return Optional.ofNullable(clazz.cast(eventBusArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEventBusResponse, T> g) {
        return obj -> g.apply((CreateEventBusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateEventBusResponse> {
        /**
         * <p>
         * The ARN of the new event bus.
         * </p>
         * 
         * @param eventBusArn
         *        The ARN of the new event bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBusArn(String eventBusArn);
    }

    static final class BuilderImpl extends CloudWatchEventsResponse.BuilderImpl implements Builder {
        private String eventBusArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventBusResponse model) {
            super(model);
            eventBusArn(model.eventBusArn);
        }

        public final String getEventBusArn() {
            return eventBusArn;
        }

        @Override
        public final Builder eventBusArn(String eventBusArn) {
            this.eventBusArn = eventBusArn;
            return this;
        }

        public final void setEventBusArn(String eventBusArn) {
            this.eventBusArn = eventBusArn;
        }

        @Override
        public CreateEventBusResponse build() {
            return new CreateEventBusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
