/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.HistoryItemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAlarmHistoryRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, DescribeAlarmHistoryRequest> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAlarmHistoryRequest.getter(DescribeAlarmHistoryRequest::alarmName)).setter(DescribeAlarmHistoryRequest.setter(Builder::alarmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()}).build();
    private static final SdkField<String> HISTORY_ITEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAlarmHistoryRequest.getter(DescribeAlarmHistoryRequest::historyItemTypeAsString)).setter(DescribeAlarmHistoryRequest.setter(Builder::historyItemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoryItemType").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeAlarmHistoryRequest.getter(DescribeAlarmHistoryRequest::startDate)).setter(DescribeAlarmHistoryRequest.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeAlarmHistoryRequest.getter(DescribeAlarmHistoryRequest::endDate)).setter(DescribeAlarmHistoryRequest.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeAlarmHistoryRequest.getter(DescribeAlarmHistoryRequest::maxRecords)).setter(DescribeAlarmHistoryRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAlarmHistoryRequest.getter(DescribeAlarmHistoryRequest::nextToken)).setter(DescribeAlarmHistoryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAME_FIELD, HISTORY_ITEM_TYPE_FIELD, START_DATE_FIELD, END_DATE_FIELD, MAX_RECORDS_FIELD, NEXT_TOKEN_FIELD));
    private final String alarmName;
    private final String historyItemType;
    private final Instant startDate;
    private final Instant endDate;
    private final Integer maxRecords;
    private final String nextToken;

    private DescribeAlarmHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.alarmName = builder.alarmName;
        this.historyItemType = builder.historyItemType;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    public String alarmName() {
        return this.alarmName;
    }

    public HistoryItemType historyItemType() {
        return HistoryItemType.fromValue(this.historyItemType);
    }

    public String historyItemTypeAsString() {
        return this.historyItemType;
    }

    public Instant startDate() {
        return this.startDate;
    }

    public Instant endDate() {
        return this.endDate;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.historyItemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmHistoryRequest)) {
            return false;
        }
        DescribeAlarmHistoryRequest other = (DescribeAlarmHistoryRequest)((Object)obj);
        return Objects.equals(this.alarmName(), other.alarmName()) && Objects.equals(this.historyItemTypeAsString(), other.historyItemTypeAsString()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAlarmHistoryRequest").add("AlarmName", (Object)this.alarmName()).add("HistoryItemType", (Object)this.historyItemTypeAsString()).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("MaxRecords", (Object)this.maxRecords()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmName": {
                return Optional.ofNullable(clazz.cast(this.alarmName()));
            }
            case "HistoryItemType": {
                return Optional.ofNullable(clazz.cast(this.historyItemTypeAsString()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmHistoryRequest, T> g) {
        return obj -> g.apply((DescribeAlarmHistoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private String alarmName;
        private String historyItemType;
        private Instant startDate;
        private Instant endDate;
        private Integer maxRecords;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmHistoryRequest model) {
            super(model);
            this.alarmName(model.alarmName);
            this.historyItemType(model.historyItemType);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.maxRecords(model.maxRecords);
            this.nextToken(model.nextToken);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getHistoryItemTypeAsString() {
            return this.historyItemType;
        }

        @Override
        public final Builder historyItemType(String historyItemType) {
            this.historyItemType = historyItemType;
            return this;
        }

        @Override
        public final Builder historyItemType(HistoryItemType historyItemType) {
            this.historyItemType(historyItemType.toString());
            return this;
        }

        public final void setHistoryItemType(String historyItemType) {
            this.historyItemType = historyItemType;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAlarmHistoryRequest build() {
            return new DescribeAlarmHistoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAlarmHistoryRequest> {
        public Builder alarmName(String var1);

        public Builder historyItemType(String var1);

        public Builder historyItemType(HistoryItemType var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder maxRecords(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

