/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsResponse;

public class ListMetricStreamsIterable
implements SdkIterable<ListMetricStreamsResponse> {
    private final CloudWatchClient client;
    private final ListMetricStreamsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMetricStreamsIterable(CloudWatchClient client, ListMetricStreamsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMetricStreamsResponseFetcher();
    }

    public Iterator<ListMetricStreamsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMetricStreamsResponseFetcher
    implements SyncPageFetcher<ListMetricStreamsResponse> {
        private ListMetricStreamsResponseFetcher() {
        }

        public boolean hasNextPage(ListMetricStreamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMetricStreamsResponse nextPage(ListMetricStreamsResponse previousPage) {
            if (previousPage == null) {
                return ListMetricStreamsIterable.this.client.listMetricStreams(ListMetricStreamsIterable.this.firstRequest);
            }
            return ListMetricStreamsIterable.this.client.listMetricStreams((ListMetricStreamsRequest)((Object)ListMetricStreamsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

