/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightRule> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(InsightRule.getter(InsightRule::name)).setter(InsightRule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(InsightRule.getter(InsightRule::state)).setter(InsightRule.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schema").getter(InsightRule.getter(InsightRule::schema)).setter(InsightRule.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Definition").getter(InsightRule.getter(InsightRule::definition)).setter(InsightRule.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATE_FIELD, SCHEMA_FIELD, DEFINITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String state;
    private final String schema;
    private final String definition;

    private InsightRule(BuilderImpl builder) {
        this.name = builder.name;
        this.state = builder.state;
        this.schema = builder.schema;
        this.definition = builder.definition;
    }

    public final String name() {
        return this.name;
    }

    public final String state() {
        return this.state;
    }

    public final String schema() {
        return this.schema;
    }

    public final String definition() {
        return this.definition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightRule)) {
            return false;
        }
        InsightRule other = (InsightRule)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.definition(), other.definition());
    }

    public final String toString() {
        return ToString.builder((String)"InsightRule").add("Name", (Object)this.name()).add("State", (Object)this.state()).add("Schema", (Object)this.schema()).add("Definition", (Object)this.definition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InsightRule, T> g) {
        return obj -> g.apply((InsightRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String state;
        private String schema;
        private String definition;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightRule model) {
            this.name(model.name);
            this.state(model.state);
            this.schema(model.schema);
            this.definition(model.definition);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        @Transient
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getDefinition() {
            return this.definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        @Transient
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public InsightRule build() {
            return new InsightRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightRule> {
        public Builder name(String var1);

        public Builder state(String var1);

        public Builder schema(String var1);

        public Builder definition(String var1);
    }
}

